\name{SEsamples}
\alias{SEsamples}
\docType{data}
\title{
Bootstrap Samples for Simple 2-State Model
}

\description{
Parametric bootstrap samples for a 2-state hidden Markov model used to compute
standard errors. 
}

\usage{data("SEsamples")}

\format{
  A matrix with 1000 rows for each sample, 12 columns for each parameter of the model, 
  including the parameters that are fixed at their boundary values. 
}
\details{
The bootstrap sample was generated by the following code:

\preformatted{require(depmixS4)
library(hmmr)
data(simplehmm)

# define the model
set.seed(214)
mod1 <- depmix(obs~1,data=simplehmm,nstates=2,
	family=multinomial("identity"), respst=c(.6,0,.4,0,.2,.8), trst=runif(4), inst=c(1,0))

# fit the model
fm1 <- fit(mod1,emcontrol=em.control(random.start=FALSE))

# compute bootstrap samples
nsamples <- 1000
SEsamples <- matrix(0,ncol=npar(fm1),nrow=nsamples)

for(i in 1:nsamples) {
	sample <- simulate(fm1)
	fmsam <- fit(sample,emcontrol=em.control(random.start=FALSE))
	SEsamples[i,] <- getpars(fmsam)
}
}
}

\examples{
data(SEsamples)
# standard errors
bootses <- apply(SEsamples,2,sd)
bootses[which(bootses==0)] <- NA
bootses
# compare with standard errors from finite differences
library(hmmr)
data(simplehmm)
# define the model
set.seed(214)
mod1 <- depmix(obs~1,data=simplehmm,nstates=2,
	family=multinomial("identity"), respst=c(.6,0,.4,0,.2,.8), trst=runif(4), inst=c(1,0))
# fit the model
fm1 <- fit(mod1,emcontrol=em.control(random.start=FALSE))
ses <- cbind(standardError(fm1),bootses)
ses
}
\keyword{datasets}
