% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{pull_terms.asreml}
\alias{pull_terms.asreml}
\title{Pull fixed and random terms from a model formula}
\usage{
\method{pull_terms}{asreml}(model)
}
\arguments{
\item{model}{A fitted model object with a \code{formula} method that returns a
list containing \code{fixed} and \code{random} formula components.}
}
\value{
A named list with components:
\item{fixed}{Character vector of labels for fixed-effect terms.}
\item{random}{Character vector of labels for random-effect terms.}
}
\description{
Extract the labels of fixed and random terms from a model object that exposes
a formula with \code{fixed} and \code{random} components (for example objects produced
by asreml::asreml). The function returns a named list containing two character
vectors: \code{fixed} and \code{random}.
}
\keyword{internal}
