% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zigzagHMC.R
\name{getZigzagSample}
\alias{getZigzagSample}
\title{Draw one MTN sample with Zigzag-HMC or Zigzag-NUTS}
\usage{
getZigzagSample(position, momentum = NULL, nutsFlg, engine, stepSize = NULL)
}
\arguments{
\item{position}{a d-dimensional initial position vector.}

\item{momentum}{a d-dimensional initial momentum vector.}

\item{nutsFlg}{logical. If \code{TRUE} the No-U-Turn sampler will be used (Zigzag-NUTS).}

\item{engine}{list. Its \code{engine} element is a pointer to the Zigzag-HMC engine
(or Zigzag-NUTS engine) C++ object that implements fast computations for
Zigzag-HMC (or Zigzag-NUTS).}

\item{stepSize}{step size for Zigzag-HMC. If \code{nutsFlg = TRUE}, \code{engine} contains
the base step size for Zigzag-NUTS).}
}
\value{
one MCMC sample from the target MTN.
}
\description{
Simulate the Zigzag-HMC or Zigzag-NUTS dynamics on a given MTN.
}
\note{
\code{getZigzagSample} is particularly efficient when the target MTN has a random
mean and covariance/precision where one can reuse the Zigzag-HMC engine object while
updating the mean and covariance. The following example demonstrates such a use.
}
\examples{
set.seed(1)
n <- 1000
d <- 10
samples <- array(0, c(n, d))

# initialize MTN mean and precision
m <- rnorm(d, 0, 1)
prec <- rWishart(n = 1, df = d, Sigma = diag(d))[, , 1]
# call createEngine once
engine <- createEngine(dimension = d, lowerBounds = rep(0, d),
 upperBounds = rep(Inf, d), seed = 1, mean = m, precision = prec)

HZZtime <- sqrt(2) / sqrt(min(mgcv::slanczos(
 A = prec, k = 1,
 kl = 1
)[['values']]))

currentSample <- rep(0.1, d)
for (i in 1:n) {
  m <- rnorm(d, 0, 1)
  prec <- rWishart(n = 1, df = d, Sigma = diag(d))[,,1]
  setMean(engine = engine, mean = m)
  setPrecision(engine = engine, precision = prec)
  currentSample <- getZigzagSample(position = currentSample,
                                   nutsFlg = FALSE,
                                   engine = engine,
                                   stepSize = HZZtime)
  samples[i,] <- currentSample
}
}
\seealso{
\code{\link[=zigzagHMC]{zigzagHMC()}}, \code{\link[=drawLaplaceMomentum]{drawLaplaceMomentum()}}
}
