/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the LICENSE file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "H5private.h"   
#include "H5Eprivate.h"  
#include "H5FLprivate.h" 
#include "H5UCprivate.h" 

H5FL_DEFINE_STATIC(H5UC_t);

H5UC_t *
H5UC_create(void *o, H5UC_free_func_t free_func)
{
    H5UC_t *ret_value; 

    FUNC_ENTER_NOAPI(NULL)

    
    assert(o);
    assert(free_func);

    
    if (NULL == (ret_value = H5FL_MALLOC(H5UC_t)))
        HGOTO_ERROR(H5E_RS, H5E_NOSPACE, NULL, "memory allocation failed");

    
    ret_value->o         = o;
    ret_value->n         = 1;
    ret_value->free_func = free_func;

done:
    FUNC_LEAVE_NOAPI(ret_value)
} 

herr_t
H5UC_decr(H5UC_t *rc)
{
    herr_t ret_value = SUCCEED; 

    FUNC_ENTER_NOAPI(FAIL)

    
    assert(rc);
    assert(rc->o);
    assert(rc->n > 0);
    assert(rc->free_func);

    
    rc->n--;

    
    if (rc->n == 0) {
        if ((rc->free_func)(rc->o) < 0) {
            rc = H5FL_FREE(H5UC_t, rc);
            HGOTO_ERROR(H5E_RS, H5E_CANTFREE, FAIL, "memory release failed");
        } 
        rc = H5FL_FREE(H5UC_t, rc);
    } 

done:
    FUNC_LEAVE_NOAPI(ret_value)
} 
