% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_theme_guardian.R
\name{gt_theme_guardian}
\alias{gt_theme_guardian}
\title{Apply Guardian theme to a \code{gt} table}
\usage{
gt_theme_guardian(gt_object, ...)
}
\arguments{
\item{gt_object}{An existing gt table object of class \code{gt_tbl}}

\item{...}{Optional additional arguments to \code{gt::table_options()}}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
Apply Guardian theme to a \code{gt} table
}
\section{Figures}{

\if{html}{\figure{gt_guardian.png}{options: width=500}}
}

\section{Function ID}{

1-4
}

\examples{

library(gt)
themed_tab <- head(mtcars) \%>\%
  gt() \%>\%
  gt_theme_guardian()
}
\seealso{
Other Themes: 
\code{\link{gt_plt_bullet}()},
\code{\link{gt_plt_conf_int}()},
\code{\link{gt_plt_dot}()},
\code{\link{gt_theme_538}()},
\code{\link{gt_theme_dark}()},
\code{\link{gt_theme_dot_matrix}()},
\code{\link{gt_theme_espn}()},
\code{\link{gt_theme_excel}()},
\code{\link{gt_theme_nytimes}()},
\code{\link{gt_theme_pff}()}
}
\concept{Themes}
