% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_blinded_info.R
\name{calculate_blinded_info}
\alias{calculate_blinded_info}
\title{Calculate blinded statistical information}
\usage{
calculate_blinded_info(
  data,
  ratio = 1,
  lambda1_planning,
  lambda2_planning,
  event_gap = NULL
)
}
\arguments{
\item{data}{A data frame containing the blinded interim data. Must include
columns \code{events} (number of events) and \code{tte} (total exposure=follow-up time).}

\item{ratio}{Planned allocation ratio (experimental / control). Default is 1.}

\item{lambda1_planning}{Planned event rate for the control group.}

\item{lambda2_planning}{Planned event rate for the experimental group.}

\item{event_gap}{Optional. Gap duration (numeric) to adjust planning rates if provided.
If provided, planning rates are adjusted as lambda / (1 + lambda * gap).}
}
\value{
A list containing:
\describe{
\item{blinded_info}{Estimated statistical information.}
\item{dispersion_blinded}{Estimated dispersion parameter (k).}
\item{lambda_blinded}{Estimated overall event rate.}
\item{lambda1_adjusted}{Re-estimated control rate.}
\item{lambda2_adjusted}{Re-estimated experimental rate.}
}
}
\description{
Estimates the blinded dispersion and event rate from aggregated interim data
and calculates the observed statistical information for the log rate ratio,
assuming the planned allocation ratio and treatment effect.
}
\examples{
interim <- data.frame(events = c(1, 2, 1, 3), tte = c(0.8, 1.0, 1.2, 0.9))
calculate_blinded_info(
  interim,
  ratio = 1,
  lambda1_planning = 0.5,
  lambda2_planning = 0.3
)
}
