% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PAF_calc_continuous.R
\name{print.PAF_q}
\alias{print.PAF_q}
\title{Print out PAF_q for differing risk factors}
\usage{
\method{print}{PAF_q}(x, ...)
}
\arguments{
\item{x}{A PAF_q object.}

\item{...}{Other arguments to be passed to print}
}
\value{
No return value, prints the PAF_q object to the console.
}
\description{
Print out PAF_q for differing risk factors
}
\examples{
library(splines)
library(survival)
library(parallel)
options(boot.parallel="snow")
options(boot.ncpus=2)
# The above could be set to the number of available cores on the machine
model_continuous <- glm(formula = case ~ region * ns(age, df = 5) +
sex * ns(age, df = 5) + education +exercise + ns(diet, df = 3) +
 alcohol + stress + ns(lipids,df = 3) + ns(waist_hip_ratio, df = 3) +
high_blood_pressure, family = "binomial", data = stroke_reduced)
out <- PAF_calc_continuous(model_continuous,
riskfactor_vec=c("diet","lipids","waist_hip_ratio"),
q_vec=c(0.01, 0.1,0.3,0.5,0.7,0.9),ci=FALSE,calculation_method="B",
data=stroke_reduced)
print(out)
}
