% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gisco-get-healthcare.R
\encoding{UTF-8}
\name{gisco_get_healthcare}
\alias{gisco_get_healthcare}
\title{Healthcare services in Europe}
\source{
\url{https://ec.europa.eu/eurostat/web/gisco/geodata/basic-services}.

There are no specific download rules for the datasets shown below. However,
please refer to \href{https://ec.europa.eu/eurostat/web/gisco/geodata}{the general copyright notice} and licence
provisions, which must be complied with. Permission to download and use
these data is subject to these rules being accepted.

The data are extracted from official national registers. They may contain
inconsistencies, inaccuracies and gaps, due to the heterogeneity of the
input national data.
}
\usage{
gisco_get_healthcare(
  year = c(2023, 2020),
  cache = TRUE,
  update_cache = FALSE,
  cache_dir = NULL,
  verbose = FALSE,
  country = NULL
)
}
\arguments{
\item{year}{character string or number. Release year of the file. One of
\code{2023}, \code{2020}.}

\item{cache}{logical. Whether to do caching. Default is \code{TRUE}. See
\strong{Caching strategies} section in \code{\link[=gisco_set_cache_dir]{gisco_set_cache_dir()}}.}

\item{update_cache}{logical. Should the cached file be refreshed?. Default
is \code{FALSE}. When set to \code{TRUE} it would force a new download.}

\item{cache_dir}{character string. A path to a cache directory. See
\strong{Caching strategies} section in \code{\link[=gisco_set_cache_dir]{gisco_set_cache_dir()}}.}

\item{verbose}{logical. If \code{TRUE} displays informational messages.}

\item{country}{character vector of country codes. It could be either a
vector of country names, a vector of ISO3 country codes or a vector of
Eurostat country codes. See also \code{\link[countrycode:countrycode]{countrycode::countrycode()}}.}
}
\value{
A \code{\link[sf:sf]{sf}} object.
}
\description{
The dataset contains information on main healthcare services considered to
be 'hospitals' by Member States. The definition varies slightly from country
to country, but roughly includes the following:

\emph{"'Hospitals' comprises licensed establishments primarily engaged in
providing medical, diagnostic, and treatment services that include physician,
nursing, and other health services to in-patients and the specialised
accommodation services required by inpatients}.
}
\details{
Files are distributed \href{https://epsg.io/4326}{EPSG:4326}.

Brief description of each attribute:\tabular{ll}{
   \strong{Attribute} \tab \strong{Description} \cr
   \code{id} \tab The healthcare service identifier. This identifier is based on national identification codes, if it exists. \cr
   \code{hospital_name} \tab The name of the healthcare institution. \cr
   \code{site_name} \tab The name of the specific site or branch of a healthcare institution. \cr
   \code{lat} \tab Latitude (WGS 84). \cr
   \code{lon} \tab Longitude (WGS 84). \cr
   \code{street} \tab Street name. \cr
   \code{house_number} \tab House number. \cr
   \code{postcode} \tab Postcode. \cr
   \code{address} \tab Address information when the different components of the address are not separated in the source. \cr
   \code{city} \tab City name (sometimes refers to a region or municipality). \cr
   \code{cntr_id} \tab Country code (2 letters, ISO 3166-1 alpha-2). \cr
   \code{emergency} \tab 'yes/no' for whether the healthcare site provides emergency medical services. \cr
   \code{cap_beds} \tab Measure of capacity by number of beds (most common). \cr
   \code{cap_prac} \tab Measure of capacity by number of practitioners. \cr
   \code{cap_rooms} \tab Measure of capacity by number of rooms. \cr
   \code{facility_type} \tab Type of healthcare service (e.g., psychiatric hospital), based on national classification. \cr
   \code{public_private} \tab 'public/private' status of the healthcare service. \cr
   \code{list_specs} \tab List of specialties recognized in the EU and EEA according to the 2005 EU Directive (Annex V). \cr
   \code{tel} \tab Telephone number. \cr
   \code{email} \tab Email address. \cr
   \code{url} \tab URL link to the institution’s website. \cr
   \code{ref_date} \tab The date (\code{DD/MM/YYYY}) the data refers to (reference date). \cr
   \code{pub_date} \tab The publication date of the dataset by Eurostat (\code{DD/MM/YYYY}). \cr
   \code{geo_qual} \tab Geolocation quality indicator: 1=Good, 2=Medium, 3=Low, 4=From source, -1=Unknown, -2=Not geocoded. \cr
   \code{comments} \tab Additional information on the healthcare service. \cr
}
}
\examples{
\dontshow{if (gisco_check_access()) withAutoprint(\{ # examplesIf}
health_benelux <- gisco_get_healthcare(
  country = c("BE", "NL", "LU"),
  year = 2023
)

# Plot if downloaded
if (!is.null(health_benelux)) {
  benelux <- gisco_get_countries(country = c("BE", "NL", "LU"))

  library(ggplot2)
  ggplot(benelux) +
    geom_sf(fill = "grey10", color = "grey20") +
    geom_sf(
      data = health_benelux, color = "red",
      size = 0.2, alpha = 0.25
    ) +
    theme_void() +
    theme(
      plot.background = element_rect(fill = "black"),
      text = element_text(color = "white"),
      panel.grid = element_blank(),
      plot.title = element_text(face = "bold", hjust = 0.5),
      plot.subtitle = element_text(face = "italic", hjust = 0.5)
    ) +
    labs(
      title = "Healthcare services", subtitle = "Benelux (2023)",
      caption = "Source: Eurostat, Healthcare 2023 dataset."
    ) +
    coord_sf(crs = 3035)
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other basic services datasets:
\code{\link{gisco_get_education}()}
}
\concept{services}
