% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PaletteColors.R
\name{scale_color_gogh}
\alias{scale_color_gogh}
\title{Creating the color scale for Van Gogh Colors}
\usage{
scale_color_gogh(
  palette = "starryNight",
  discrete = TRUE,
  reverse = FALSE,
  ...
)
}
\arguments{
\item{palette}{the ggRtsy painting color palette of choice}

\item{discrete}{Boolean if color aesthetic is discrete}

\item{reverse}{Boolean, will be TRUE if the user wants the palette reversed}

\item{...}{further arguments passed to [ggRtsy::scale_color_gogh()]}
}
\value{
A ggplot2 color scale.
  If `discrete` is TRUE, it returns a discrete color scale; otherwise, a continuous color scale.
}
\description{
Creating the color scale for Van Gogh Colors
}
\examples{
if (require(ggplot2)) {
  data <- data.frame(c = LETTERS[1:3],x = c(1,5,7),y = c(5,9,13))
  ggplot(data, aes(x,y,color = c))+geom_point()+scale_color_gogh()
}
}
