% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_gff.R
\name{read_gff}
\alias{read_gff}
\title{Read GFF Files}
\usage{
read_gff(path, fields = NULL)
}
\arguments{
\item{path}{A character string specifying the directory containing GFF files
or the file path to a single GFF file.}

\item{fields}{An optional vector of character strings specifying the fields
to extract from the GFF files.}
}
\value{
A data frame containing the combined data from the GFF files.
}
\description{
This function reads GFF files from a specified directory or file path and
combines them into a single data frame.
}
\details{
This function can read multiple GFF files from a directory or a
  single GFF file. It processes each file, extracts the specified fields (if
  provided), adds a 'name' column with the filename, and combines the data
  frames from all files into one.
}
\examples{
\dontrun{
# Read GFF files from a directory
gff_data <- read_gff("path/to/directory")

# Read a single GFF file
gff_data <- read_gff("path/to/file.gff")

# Read specific fields from GFF files
gff_data <- read_gff(
"path/to/directory",
fields = c("seqid", "start", "end", "attributes")
)
}
}
