% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneviewer.R
\name{GC_links}
\alias{GC_links}
\title{Add Links to GC Chart}
\usage{
GC_links(
  GC_chart,
  group = NULL,
  data = NULL,
  value1 = NULL,
  value2 = NULL,
  cluster = NULL,
  curve = TRUE,
  measure = "identity",
  show_links = TRUE,
  label = TRUE,
  normal_color = "#969696",
  inverted_color = "#d62728",
  use_group_colors = FALSE,
  color_bar = TRUE,
  colorBarOptions = list(),
  linkWidth = NULL,
  linkStyle = list(),
  labelStyle = list(),
  ...
)
}
\arguments{
\item{GC_chart}{Gene chart object.}

\item{group}{The name of the column in the data to create value pairs from.}

\item{data}{data.frame containing linking data.}

\item{value1}{Optional vector of group values to generate links for.}

\item{value2}{Optional vector of group values to generate links for.}

\item{cluster}{Numeric or character vector or NULL; specifies which clusters.}

\item{curve}{Logical; if `TRUE`, links are curved, otherwise straight.}

\item{measure}{Character; specifies which measure to use for link color intensity. Should be "identity", "similarity", or "none".}

\item{show_links}{Logical; if `TRUE`, links are shown, otherwise hidden.}

\item{label}{Logical; if `TRUE`, shows measure labels on the links, otherwise hidden.}

\item{normal_color}{Color for the links in their normal state.}

\item{inverted_color}{Color for inverted links.}

\item{use_group_colors}{Logical; if `TRUE`, color links by group.}

\item{color_bar}{Logical; if `TRUE`, the color bar is displayed.}

\item{colorBarOptions}{List of options to customize the color bar appearance.}

\item{linkWidth}{Numeric; specifies the width of the links. A value of `1`
represents full width, and `0` represents no width.}

\item{linkStyle}{A list of CSS styles to apply to the links.}

\item{labelStyle}{A list of CSS styles specifically for the labels.}

\item{...}{Additional arguments passed to the links.}
}
\value{
Modified `GC_chart` object with added links.
}
\description{
Add links generated by `get_links` to a `GC_chart` object. Links are added
to the graph by their respective rowIDs.
}
\examples{
# Add links between all groups in each cluster
genes_data <- data.frame(
  start = c(10, 90, 130, 170, 240, 250, 300, 340, 380, 420),
  end = c(40, 120, 160, 200, 210, 270, 330, 370, 410, 450),
  name = c('Gene 1', 'Gene 2', 'Gene 3', 'Gene 4', 'Gene 5',
           'Gene 6', 'Gene 7', 'Gene 8', 'Gene 9', 'Gene 10'),
  group = c('A', 'B', 'C', 'A', 'B', 'C', 'A', 'B', 'C', 'D'),
  identity = c(NA, NA, NA, 50, 40, 100, 60, 65, 20, NA),
  similarity = c(NA, NA, NA, 40, 30, 90, 50, 55, 10, NA),
  cluster = c(1, 1, 1, 2, 2, 2, 3, 3, 3, 3)
)
GC_chart(genes_data,
         cluster = "cluster",
         height = "200px") \%>\%
  GC_links(
    group = "group",
    value1 = "A",
    value2 = "B",
    measure = "identity",
    label = FALSE) \%>\%
  GC_labels(label = "group")

# Add links between group A of cluster 1 and A and B of cluster 2
GC_chart(genes_data,
         cluster = "cluster",
         height = "200px") \%>\%
         GC_labels(label = "group") \%>\%
         GC_links(group = "group",
                   value1 = c("A", "A"),
                   value2 = c("B", "A"),
                   label = FALSE,
                   cluster = c(1,2))

# Style links and color bar
GC_chart(genes_data,
         cluster = "cluster",
         height = "200px"
) \%>\%
  GC_links(
    group = "group",
    data = NULL,
    curve = TRUE,
    measure = "identity",
    show_links = TRUE,
    label = TRUE,
    normal_color = "#1f77b4",
    inverted_color = "#d62728",
    use_group_colors = FALSE,
    color_bar = TRUE,
    colorBarOptions = list(
      x = 0,
      y = 24,
      width = 10,
      height = 60,
      labelOptions = list(
        fontSize = 8,
        xOffset = 2,
        yOffset = 0
        # Any other CSS style
      ),
      titleOptions = list(
        fontSize = 10,
        xOffset = 2,
        yOffset = 0
        # Any other CSS style
      ),
      barOptions = list(
        stroke = "#000",
        strokeWidth = 0.5,
        opacity = 1
        # Any other CSS style
      )
    ),
    linkWidth = 1,
    linkStyle = list(
      stroke = "black",
      strokeWidth = 0.5,
      fillOpacity = 0.4
      # Any other CSS style
    ),
    labelStyle = list(
      fontSize = "8px"
      # Any other CSS style
    )
  ) \%>\%
  GC_labels(label = "group", cluster = 1) \%>\%
  GC_clusterLabel()
}
\seealso{
* [get_links()]
}
