% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmPlotMetricSubspaces.R
\name{dmPlotMetricSubspaces}
\alias{dmPlotMetricSubspaces}
\title{Create an image file for metric subspaces}
\usage{
dmPlotMetricSubspaces(
  plotMetricSubspaceParametersList = list(),
  imageFileName,
  title,
  columnIndices,
  evaluateDataSourceFileName = "",
  plotEvaluateDataSourceParameters = NULL
)
}
\arguments{
\item{plotMetricSubspaceParametersList}{List of plot parameters for metric subspaces for different levels,
see dmPlotMetricSubspaceParameters().}

\item{imageFileName}{Name of image file}

\item{title}{Title of image}

\item{columnIndices}{Vector of two column indices that are used for the two-dimensional projection.
Indices refer to indices of active columns of the data source used to create the data model.}

\item{evaluateDataSourceFileName}{Name of evaluated data source file}

\item{plotEvaluateDataSourceParameters}{Plot parameters for evaluated data source,
see dmPlotEvaluateDataSourceParameters().}
}
\value{
None
}
\description{
Create an image file containing two-dimensional projections of generative data
contained in metric subspaces in a data model and optionally an evaluated data source.
Plot parameters are passed by a list of generated plot parameters for different levels
by dmPlotMetricSubspaceParameters() and by dmPlotEvaluateDataSourceParameters().
Data points are drawn in the order generative data contained in metric subspaces by increasing level
and evaluated data source.
}
\examples{
\dontrun{
dmRead("dm.bin", "gd.bin")
dmPlotMetricSubspaces(
  list(dmPlotMetricSubspaceParameters(level = 0.5,
                                       labels = c("*"),
                                       percent = 100,
                                       boundary = TRUE,
                                       color = "red",
                                       backgroundPercent = 0,
                                       backgroundColor = "red",
                                       backgroundReset = TRUE,
                                       plotLabels = TRUE)),
  "ms.png",
  "Metric Subspaces for the Iris Dataset",
  c(3, 4),
  "ds.bin",
  dmPlotEvaluateDataSourceParameters(0.67))}
}
