% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fromto.R
\name{fromto}
\alias{fromto}
\title{Extract All Items of a Vector Between Two Patterns}
\usage{
fromto(
  x,
  from,
  to,
  from_i = 1,
  to_i = 1,
  shift_from = 0,
  shift_to = 0,
  remove_empty_item = TRUE
)
}
\arguments{
\item{x}{A vector.}

\item{from}{A pattern, use NA to start with the first item.}

\item{to}{Another pattern, use NA to stop with the last item.}

\item{from_i}{If the from pattern matches multiple times, which one is to be
used.}

\item{to_i}{Analogously to from_i.}

\item{shift_from}{The number of items to shift from the item selected via
from and from_i.}

\item{shift_to}{Analogously to shift_from.}

\item{remove_empty_item}{Remove empty items?}
}
\value{
The extracted vector.
}
\description{
This comes in handy to cut lines from a file read by \code{\link{readLines}}.
}
\examples{
foo <- c("First", "f1", "A", "f2", rep("B", 4), "t1", "f3", "C", "t2",
         rep("D", 4), "t3", "Last")
fromto(foo, "^f", "^t")
fromto(foo, NA, "^t")
fromto(foo, "^f", NA)
fromto(foo, "^f", "^t", from_i = 2)
fromto(foo, "^f", "^t", from_i = 2, to_i = 2)
fromto(foo, "^f", "^t", from_i = 2, to_i = 2, shift_from = 1, shift_to = -1)
fromto(foo, "^f", "^t", from_i = 2, to_i = 2, shift_from = -1, shift_to = 2)
}
\seealso{
Other searching functions: 
\code{\link{compare_vectors}()},
\code{\link{file_modified_last}()},
\code{\link{find_files}()},
\code{\link{grep_file}()},
\code{\link{missing_docs}},
\code{\link{runsed}()},
\code{\link{search_files}()},
\code{\link{search_rows}()},
\code{\link{summary.filesearch}()}
}
\concept{searching functions}
