% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_umlauts_to_utf8.R
\name{convert_umlauts_to_utf8}
\alias{convert_umlauts_to_utf8}
\alias{convert_umlauts_to_utf8.character}
\alias{convert_umlauts_to_utf8.data.frame}
\title{Convert German Umlauts to a More or Less Suitable `utf8` Representation}
\usage{
convert_umlauts_to_utf8(x)

\method{convert_umlauts_to_utf8}{character}(x)

\method{convert_umlauts_to_utf8}{data.frame}(x)
}
\arguments{
\item{x}{A string or \code{data.frame}.}
}
\value{
\bold{x} with the umlauts converted to utf8.
}
\description{
Convert German Umlauts to a More or Less Suitable `utf8` Representation
}
\examples{
string <- "_(\xdcLH)"
print(string)
print(convert_umlauts_to_utf8(string))
string <- "this is _(\xdcLH) string"
df <- data.frame(v1 = c(string, "foobar"),
                 v2 = c("foobar", string), v3 = 3:4)
names(df)[3] <- "y_(\xdcLH)"
convert_umlauts_to_utf8(df)
convert_umlauts_to_ascii(convert_umlauts_to_utf8(df))
}
\seealso{
Other German umlaut converters: 
\code{\link{convert_umlauts_to_ascii}()},
\code{\link{convert_umlauts_to_tex}()},
\code{\link{get_german_umlauts}()}
}
\concept{German umlaut converters}
