% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/project_directories.R
\name{project_add_directory}
\alias{project_add_directory}
\title{Add custom directories to an existing project}
\usage{
project_add_directory(project_path, key, label, path)
}
\arguments{
\item{project_path}{Character string. Absolute path to the project root directory.}

\item{key}{Character string. Internal key for the directory (e.g., "analysis_archive").
Must be unique within the project's directory configuration.}

\item{label}{Character string. Human-readable label for the directory (e.g., "Analysis Archive").}

\item{path}{Character string. Relative path where the directory should be created
(e.g., "analysis/archive"). Must be relative, not absolute. Parent directories
will be created as needed.}
}
\value{
List with success status and directory information:
\itemize{
\item \code{success}: Logical indicating whether the operation succeeded
\item \code{directory}: List containing key, label, path, absolute_path, and created flag
\item \code{error}: Character string with error message (only present if success is FALSE)
}
}
\description{
Adds new directories to a project's configuration and creates them on the
filesystem. This function is used by the GUI to allow users to add custom
directories to their project structure without modifying existing directories.
}
\details{
This function performs the following steps:
\enumerate{
\item Validates all input arguments
\item Reads the project's config.yml file
\item Checks for duplicate keys in existing directories
\item Adds the new directory to the directories section
\item Writes the updated config.yml back to disk
\item Creates the directory on the filesystem (with recursive creation)
}

The function follows a non-destructive, additive-only approach. It will not:
\itemize{
\item Rename existing directories
\item Delete existing directories
\item Modify existing directory paths
\item Change the project type
}
}
\section{Safety}{

The function includes several safety checks:
\itemize{
\item Rejects absolute paths (must be relative)
\item Rejects paths containing ".." (no directory traversal)
\item Checks for duplicate keys before adding
\item Wraps filesystem operations in error handling
}
}

\keyword{internal}
