% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ai_sync.R
\name{ai_sync_context}
\alias{ai_sync_context}
\title{Sync AI Assistant Context Files}
\usage{
ai_sync_context(config_file = NULL, force = FALSE, verbose = TRUE)
}
\arguments{
\item{config_file}{Path to configuration file (default: auto-detect settings.yml/settings.yml)}

\item{force}{Logical; if TRUE, overwrite even if target is newer (default: FALSE)}

\item{verbose}{Logical; if TRUE (default), show sync messages}
}
\value{
Invisible list with sync results
}
\description{
Copies content from the canonical AI assistant file to all other AI files,
adding a warning header to non-canonical files.
}
\details{
This function reads the \code{ai.canonical_file} setting from settings.yml and
copies its content to all other AI assistant instruction files that exist
in the project.

The canonical file is copied as-is. Non-canonical files receive a warning
header indicating they are auto-synced and should not be edited directly.

Supported files:
\itemize{
\item \strong{AGENTS.md} - Cross-platform AI assistants
\item \strong{CLAUDE.md} - Claude Code
\item \strong{.github/copilot-instructions.md} - GitHub Copilot
}
}
\examples{
\donttest{
if (FALSE) {
# Sync AI context files
ai_sync_context()

# Force sync even if targets are newer
ai_sync_context(force = TRUE)

# Silent sync (for git hooks)
ai_sync_context(verbose = FALSE)
}
}

}
