% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createExpSpace.R
\name{setSeasonalTiedAttributes}
\alias{setSeasonalTiedAttributes}
\title{Creates tied attributes which tie seasonal changes in attributes to annual changes}
\usage{
setSeasonalTiedAttributes(attSel)
}
\arguments{
\item{attSel}{A char vector; the names of the attributes (perturbed/held) for 
which seasonal attributes will be tied to.}
}
\value{
A list describing tied attributes with first level corresponding to
original perturbed/held attributes, and second level a vector with tied seasonal attributes.
}
\description{
\code{setSeasonalTiedAttributes} returns a list containing tied attributes,
matching seasonal attributes to non-stratified attributes.
This list can be used to specify tied attributes in \code{createExpSpace()}
}
\examples{
attSel <- c("P_day_all_tot_m", "P_day_all_P99")
attTied <- setSeasonalTiedAttributes(attSel)
attTied
}
