% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate_attribute_change.R
\name{plotPerformanceAttributesOAT}
\alias{plotPerformanceAttributesOAT}
\title{Plots changes in attributes for a specified perturbed attribute}
\usage{
plotPerformanceAttributesOAT(
  clim,
  sim,
  attPerturb,
  attEval,
  vSel = NULL,
  cSel = NULL,
  ylim = NULL,
  baseSettings = list(),
  cex.main = 0.8,
  cex.xaxis = 0.5,
  cex.yaxis = 0.5
)
}
\arguments{
\item{clim}{list; reference climate data. \cr}

\item{sim}{list; perturbed climate from \code{generateScenarios()} \cr}

\item{attPerturb}{string; name of perturbed attribute \cr}

\item{attEval}{string; name of attribute that will be evaluated \cr}

\item{vSel}{string; variable name for selection site/aggregation \cr}

\item{cSel}{integer or string 'mean'; how to summarize multisite data - select site number or 'mean' for average \cr}

\item{ylim}{numeric vector of length 2; min and max y limits for plotting \cr}

\item{baseSettings}{list containing 'bias_base_thresh' for threshold for bias in baseline performance (%), 
and 'slope_thresh' for threshold for slope of relationship between perturbed and plotted attribute}

\item{cex.main}{number; size for title \cr}

\item{cex.xaxis}{number; size for x-axis \cr}

\item{cex.yaxis}{number; size for y-axis \cr}
}
\value{
The function returns a single plot showing changes in attribute \code{attEval} 
for changes in perturbed attribute \code{attPerturb}. 
Dashed blue lines indicate the target values for the perturbed attributes.
Green lines represent the target values for held and tied attributes.
Black line shows the median of the simulated attribute values, while the grey 
band indicates the 90% range (5th to 95th percentiles).
Red lines highlight attributes that change significantly more than the intended perturbation 
(i.e. the slope of attribute vs. perturbed attribute > \code{slope_thresh}).
Red crosses mark attributes with large biases—greater than \code{bias_base_thresh} 
relative to their observed (unperturbed) historical values.\cr
}
\description{
\code{plotPerformanceAttributesOAT} plots OAT changes in attributes based on simulated climate object, for a given perturbed attribute.
}
\examples{
\dontrun{
# load dates, precip, PET and streamflow data for Scott Creek
data('data_A5030502')
clim_ref = list(times = data_A5030502$times,P = data_A5030502$P)  
data("egScottCreekSimStoch")
attSel = colnames(sim.stoch$expSpace$targetMat)
# other attributes
attSel = c(attSel,'P_year_all_avgDwellTime','P_day_all_avgWSD',
           'P_day_all_P99.9','P_day_JJA_P99.9','P_day_SON_P99.9',
           'P_day_DJF_P99.9','P_day_MAM_P99.9')
# plot changes in attributes for perturbations in seasonality ratio
att = "P_day_all_seasRatioMarMay"
par(mfrow=c(3,3),mar=c(4,7,2,1))
# plot changes in a single attribute with respect to perturbed attrbiutes
plotPerformanceAttributesOAT(clim=clim_ref,
                             sim=sim.stoch,
                             attPerturb=att,
                             attEval=attSel,
                             cex.main = 1.5,cex.xaxis = 1,cex.yaxis = 1) 
}                                
}
