% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Generalized-Waring.R
\name{Generalized-Waring}
\alias{Generalized-Waring}
\alias{dgwar}
\alias{pgwar}
\alias{qgwar}
\alias{rgwar}
\title{Generalized Waring Distribution}
\usage{
dgwar(y, mu, k, rho, log = FALSE)

pgwar(q, mu, k, rho, lower.tail = TRUE, log.p = FALSE)

qgwar(p, mu, k, rho)

rgwar(n, mu, k, rho)
}
\arguments{
\item{y}{non-negative integer vector of count outcomes.}

\item{mu}{numeric vector of means of the distribution.}

\item{k}{non-negative numeric parameter of the distribution.}

\item{rho}{non-negative numeric parameter of the distribution.}

\item{log}{logical; if TRUE, probabilities p are given as log(p).}

\item{q}{non-negative integer vector of quantiles.}

\item{lower.tail}{logical; if TRUE, probabilities p are \eqn{P[X\leq x]}
otherwise, \eqn{P[X>x]}.}

\item{log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{p}{numeric vector of probabilities.}

\item{n}{integer number of random numbers to generate.}
}
\value{
dgwar gives the density, pgwar gives the distribution function, 
 qgwar gives the quantile function, and rgwar generates random  deviates.

 The length of the result is determined by n for rgwar, and is the maximum of 
 the lengths of the numerical arguments for the other functions.
}
\description{
These functions provide density, distribution function, quantile function,
and random number generation for the Generalized Waring Distribution.
}
\details{
The Generalized Waring distribution is a 3-parameter count distribution that
is used to model overdispersed count data.


\code{dgwar} computes the density (PMF) of the Generalized Waring
Distribution.

\code{pgwar} computes the CDF of the Generalized Waring Distribution.

\code{qwaring} computes the quantile function of the Generalized Waring
Distribution.

\code{rwaring} generates random numbers from the Generalized Waring
Distribution.

The Probability Mass Function (PMF) for the Generalized Waring (GW)
distribution is:
\deqn{f(y|a_x,k,\rho) = 
   \frac{\Gamma(a_x+\rho)\Gamma(k+\rho)\left(a_x\right)_y(k)_y}
   {y!\Gamma(\rho)\Gamma(a_x+k+\rho)(a_x+k+\rho)_y}}
Where \eqn{(\alpha)_r=\frac{\Gamma(\alpha+r)}{\Gamma(\alpha)}}, 
and \eqn{a_x, \ k, \ \rho)>0}.

The mean value is:
\deqn{E[Y]=\frac{a_x K}{\rho-1}}

Thus, we can use:
\deqn{a_x=\frac{\mu(\rho-1)}{k}}

This results in a regression model where:
\deqn{\mu=e^{X\beta}}
\deqn{\sigma^2 =
  \mu \left(1-\frac{1}{\alpha+\rho+1} \right) + 
  \mu^2\frac{(\alpha+\rho)^2}{\alpha\rho(\alpha+\rho+1)}}
}
\examples{
dgwar(0, mu=1, k=2, rho=3)
pgwar(c(0,1,2,3), mu=1, k=2, rho=3)
qgwar(0.8, mu=1, k=2, rho=3)
rgwar(10, mu=1, k=2, rho=3)

}
