% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lookup_concept_by_label.R
\name{lookup_concept_by_label}
\alias{lookup_concept_by_label}
\title{Look up concepts by label in a specific vocabulary from the Finto Skosmos API}
\usage{
lookup_concept_by_label(vocid, label, lang = NULL)
}
\arguments{
\item{vocid}{The vocabulary ID, e.g., "yso".}

\item{label}{The label to look up, e.g., "cat".}

\item{lang}{The search language, e.g., "en" or "fi". Optional.}
}
\value{
A tibble containing the best matching concept(s) with fields like uri, type, prefLabel, and altLabel.
}
\description{
Look up concepts by label in a specific vocabulary from the Finto Skosmos API
}
\examples{
result <- lookup_concept_by_label(vocid = "yso", label = "cat", lang = "en")
print(result)
}
