% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_vocabulary_types.R
\name{get_vocabulary_types}
\alias{get_vocabulary_types}
\title{Get type information for a Finto vocabulary}
\usage{
get_vocabulary_types(vocid, lang = NULL)
}
\arguments{
\item{vocid}{A Skosmos vocabulary identifier, e.g. \code{"yso"}.}

\item{lang}{Optional language code for labels, e.g. \code{"fi"} or \code{"en"}.
If \code{NULL} (default), the API's default language is used.}
}
\value{
A tibble with one row per type, typically containing columns
\code{uri}, \code{label}, and (optionally) \code{superclass}.
}
\description{
This function retrieves information about the types (classes) of objects
in a given Finto/Skosmos vocabulary, using the \verb{/types} endpoint.
}
\examples{
types <- get_vocabulary_types("yso", lang = "fi")
print(types)
}
