% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiple_entries.R
\name{fhir_melt_internal}
\alias{fhir_melt_internal}
\title{Internal function to melt multiple entries in a data.table}
\usage{
fhir_melt_internal(indexed_dt, columns, brackets, sep, id_name, all_columns)
}
\arguments{
\item{indexed_dt}{A data.table with indexed multiple entries.}

\item{columns}{A character vector specifying the names of all columns that should be melted simultaneously.
It is advisable to only melt columns that belong to the same repeating attribute.}

\item{brackets}{A character vector of length two, defining the brackets used for the indices.}

\item{sep}{A character vector of length one, the separator that was used when pasting together multiple entries.}

\item{id_name}{A character vector of length one, the name of the column that will hold the identification
of the origin of the new rows.}

\item{all_columns}{A boolean indicating whether all columns should be returned (default is FALSE).}
}
\value{
A data.table where each entry from the variables in \code{columns} appears in a separate row.
}
\description{
This function handles the core melting operation for multiple entries in an indexed data.table.
It is used internally by \code{\link[=fhir_melt]{fhir_melt()}} to separate multiple entries in a given set of columns
into individual rows.
}
\seealso{
\code{\link[=fhir_melt]{fhir_melt()}}, \code{\link[=fhir_rm_indices]{fhir_rm_indices()}}
}
