% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bkg_pois.R
\name{bkg_stations}
\alias{bkg_stations}
\title{Stations and stops}
\usage{
bkg_stations(
  ...,
  bbox = NULL,
  poly = NULL,
  predicate = "intersects",
  filter = NULL,
  epsg = 3035,
  properties = NULL,
  max = NULL
)
}
\arguments{
\item{...}{Used to construct CQL filters. Dot arguments accept an R-like
syntax that is converted to CQL queries internally. These queries basically
consist of a property name on the left, an aribtrary vector on the right,
and an operator that links both sides. If multiple queries are provided,
they will be chained with \code{AND}. The following operators and their
respective equivalents in CQL and XML are supported:

\tabular{lll}{
\strong{R} \tab \strong{CQL} \tab \strong{XML}\cr
\code{==} \tab \code{=} \tab \code{PropertyIsEqualTo}\cr
\code{!=} \tab \code{<>} \tab \code{PropertyIsNotEqualTo}\cr
\code{<} \tab \code{<} \tab \code{PropertyIsLessThan}\cr
\code{>} \tab \code{>} \tab \code{PropertyIsGreaterThan}\cr
\code{>=} \tab \code{>=} \tab \code{PropertyIsGreaterThanOrEqualTo}\cr
\code{<=} \tab \code{<=} \tab \code{PropertyIsLessThanOrEqualTo}\cr
\code{\%LIKE\%} \tab \code{LIKE} \tab \code{PropertyIsLike}\cr
\code{\%ILIKE\%} \tab \code{ILIKE} \tab\cr
\code{\%in\%} \tab \code{IN} \tab \code{PropertyIsEqualTo} and \code{Or}
}

To construct more complex queries, you can use the \code{filter} argument
to pass CQL queries directly. Also note that you can switch between
CQL and XML queries using \code{options(ffm_query_language = "xml")}.
See also \code{\link{wfs_filter}}.}

\item{bbox}{An sf geometry or a boundary box vector of the format
\code{c(xmin, ymin, xmax, ymax)}. Used as a geometric filter to include
only those geometries that relate to \code{bbox} according to the predicate
specified in \code{predicate}. If an sf geometry is provided, coordinates
are automatically transformed to ESPG:25832 (the default CRS), otherwise
they are expected to be in EPSG:25832.}

\item{poly}{An sf geometry. Used as a geometric filter to include
only those geometries that relate to \code{poly} according to the predicate
specified in \code{predicate}. Coordinates are automatically transformed to
ESPG:25832 (the default CRS).}

\item{predicate}{A spatial predicate that is used to relate the output
geometries with the object specified in \code{bbox} or \code{poly}. For
example, if \code{predicate = "within"}, and \code{bbox} is specified,
returns only those geometries that lie within \code{bbox}. Can be one of
\code{"equals"}, \code{"disjoint"}, \code{"intersects"}, \code{"touches"},
\code{"crosses"}, \code{"within"}, \code{"contains"}, \code{"overlaps"},
\code{"relate"}, \code{"dwithin"}, or \code{"beyond"}. Defaults to
\code{"intersects"}.}

\item{filter}{A character string containing a valid CQL or XML filter. This
string is appended to the query constructed through \code{...}. Use this
argument to construct more complex filters. Defaults to \code{NULL}.}

\item{epsg}{An EPSG code specifying a coordinate reference system of the
output. If you're unsure what this means, try running
\code{sf::st_crs(...)$epsg} on a spatial object that you are working with.
Defaults to 3035.}

\item{properties}{Vector of columns to include in the output.}

\item{max}{Maximum number of results to return.}
}
\value{
A dataframe with the following columns: \itemize{
\item{\code{name}}: Geographical name of the POI
\item{\code{gemeinde}}: Municipality name
\item{\code{verwaltung}}: Administrative association name
\item{\code{kreis}}: District name
\item{\code{regierungs}}: Government region name
\item{\code{bundesland}}: Federal state name
\item{\code{stop_id}: Identifier of the station or stop}
\item{\code{parent_st}: Identifier of the parent station if applicable}
\item{\code{verkehrsm}: Vehicle used at the station, comma-separated
and sorted alphabetically}
\item{\code{art}: Hierarchical position of a station. Can be: \itemize{
\item{Station: A physical structure and hierarchically superior}
\item{Haltestelle: Part of a structure and hierarchically inferior}
}}
\item{\code{tag_f_awo}: Mean departures per day in a work week}
\item{\code{tag_f_wo}: Mean departures per day in a full week}
}
}
\description{
Retrieve data on public transport stations and stops in Germany. Stations
and stops are hierarchical. This means that stations represent the
structural facilities as hierarchically superior objects and stops are
hierarchically inferiors parts of a station (e.g., a single platform
at a bus stop).
}
\section{Query language}{

By default, WFS requests use CQL (Contextual Query Language) queries for
simplicity. CQL queries only work together with GET requests. This means
that when the URL is longer than 2048 characters, they fail.
While POST requests are much more flexible and able to accommodate long
queries, XML is really a pain to work with and I'm not confident in my
approach to construct XML queries. You can control whether to send GET or
POST requests by setting \code{options(ffm_query_language = "XML")}
or \code{options(ffm_query_language = "CQL")}.
}

\examples{
\dontshow{if (getFromNamespace("ffm_run_examples", ns = "ffm")()) withAutoprint(\{ # examplesIf}
# Get all long-distance train stations
bkg_stations(verkehrsm \%LIKE\% "\%Fernzug\%", art == "Station")

# Get all platforms of long-distance train stations
bkg_stations(verkehrsm \%LIKE\% "\%Fernzug\%", art == "Haltestelle")

# Get all stops with high traffic
bkg_stations(tag_f_awo > 1000, art == "Station")

# Get all bus stops with low traffic
bkg_stations(tag_f_awo < 1, verkehrsm \%LIKE\% "\%Bus\%", art == "Station")
\dontshow{\}) # examplesIf}
}
\seealso{
\href{https://sgx.geodatenzentrum.de/web_public/gdz/dokumentation/deu/poi-open.pdf}{\code{wfs_poi_open} documentation}

\href{https://mis.bkg.bund.de/trefferanzeige?docuuid=461731F5-62B1-45A9-8E7E-BF6AF93E3EFA}{\code{wfs_poi_open} MIS record}

Other points of interest: 
\code{\link{bkg_airports}()},
\code{\link{bkg_crossings}()},
\code{\link{bkg_heliports}()},
\code{\link{bkg_kilometrage}()},
\code{\link{bkg_seaports}()},
\code{\link{bkg_trauma_centers}()}
}
\concept{points of interest}
