% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_concepts.R
\name{\%or\%}
\alias{\%or\%}
\alias{\%|\%}
\title{Union (Logical OR) of Fuzzy Sets}
\usage{
S1 \%|\% S2
}
\arguments{
\item{S1}{A \code{Set}}

\item{S2}{A \code{Set}}
}
\value{
Returns the union of \code{S1} and \code{S2}.
}
\description{
Union (Logical OR) of Fuzzy Sets
}
\details{
Both \code{S1} and \code{S2} must be Sets.
}
\examples{
# Build two sparse sets
S <- Set$new(attributes = c("A", "B", "C"))
S$assign(A = 1, B = 1)
T <- Set$new(attributes = c("A", "B", "C"))
T$assign(C = 1)

# Union
S \%|\% T

}
