% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/are_types.r
\name{are-type-predicates}
\alias{are-type-predicates}
\alias{are_list}
\alias{are_atomic}
\alias{are_vector}
\alias{are_integer}
\alias{are_double}
\alias{are_complex}
\alias{are_character}
\alias{are_logical}
\alias{are_raw}
\alias{are_bytes}
\alias{are_null}
\title{Type predicates}
\usage{
are_list(..., .n = NULL, .all = FALSE)

are_atomic(..., .n = NULL, .all = FALSE)

are_vector(..., .n = NULL, .all = FALSE)

are_integer(..., .n = NULL, .all = FALSE)

are_double(..., .n = NULL, .finite = NULL, .all = FALSE)

are_complex(..., .n = NULL, .finite = NULL, .all = FALSE)

are_character(..., .n = NULL, .all = FALSE)

are_logical(..., .n = NULL, .all = FALSE)

are_raw(..., .n = NULL, .all = FALSE)

are_bytes(..., .n = NULL, .all = FALSE)

are_null(..., .all = FALSE)
}
\arguments{
\item{...}{Objects to be tested.}

\item{.n}{Expected lengths of the vectors.}

\item{.all}{If \code{TRUE}, return boolean of whether all arguments returned
\code{TRUE}.}

\item{.finite}{Whether all values of the vectors are finite. The
non-finite values are \code{NA}, \code{Inf}, \code{-Inf} and \code{NaN}. Setting this
to something other than \code{NULL} can be expensive because the whole
vector needs to be traversed and checked.}
}
\value{
Named logical, or unnamed boolean if \code{.all} is \code{TRUE}.
}
\description{
Wrappers around \link[rlang:rlang-package]{rlang} type predicates that
allow multiple objects to be passed. The following documentation is adapted
from the rlang \link[rlang:type-predicates]{documentation}:

These type predicates aim to make type testing in R more
consistent. They are wrappers around \code{\link[base:typeof]{base::typeof()}}, so operate
at a level beneath S3/S4 etc.

Compared to base R functions:
\itemize{
\item The predicates for vectors include the \code{.n} argument for
pattern-matching on the vector length.
\item Unlike \code{is.atomic()} in R < 4.4.0, \code{are_atomic()} does not return \code{TRUE}
for \code{NULL}. Starting in R 4.4.0 \code{is.atomic(NULL)} returns FALSE.
\item Unlike \code{is.vector()}, \code{are_vector()} tests if an object is an
atomic vector or a list. \code{is.vector} checks for the presence of
attributes (other than name).
}
}
\details{
The optional inputs of \code{.n} and \code{.finite} can be given inputs
that map to the arguments in \code{...}. If a unnamed vector/list, the input must
either be the same length as the number of arguments given to \code{...}, or
length 1: which is then recycled to the number number of arguments
given to \code{...}. Alternatively, a named vector/list can be given, where
the values for matching named elements are passed to the type predicate,
but unmatched names are passed NULL.
}
\examples{
x <- 1
y <- list()
z <- mean

are_list(x, y, z, list(1))

# `.all` can be given to test if all inputs
# evaluate to TRUE
are_list(x, y, z, list(1), .all = TRUE)

# scalar inputs to `.n` and `.finite` are
# recycled to number of inputs
are_list(x, y, z, list(1), .n = 1)

# inputs to `.n` and `.finite` matching the
# number of inputs are applied sequentially
are_list(x, y, z, list(1), .n = c(1, 0, 1, 2))

# named inputs to `.n` and `.finite` are applied
# to the matching input names, with the other inputs
# being given NULL
are_list(x, y, z, list(1), .n = c(y = 1, "list(1)" = 2))
}
\seealso{
\link{are-bare-type-predicates} \link{are-scalar-type-predicates}
}
