% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multifabCIhom.R
\name{multifabCIhom}
\alias{multifabCIhom}
\title{Multigroup FAB t-intervals for the homoscedastic model}
\usage{
multifabCIhom(y, g, alpha = 0.05, prop = 0.5)
}
\arguments{
\item{y}{a numeric vector of data}

\item{g}{a group membership vector, of the same length as y}

\item{alpha}{the type I error rate, so 1-alpha is the coverage rate}

\item{prop}{the proportion of groups to obtain the sample variance estimate}
}
\description{
Computation of 1-alpha FAB t-intervals for homoscedastic 
multigroup data.
}
\details{
For each group j, this function computes an estimate of 
the parameters in a hierarchical model for means 
using data from other groups, and uses this information to 
construct a FAB t-interval for group j. These intervals have 
1-alpha frequentist coverage, assuming within-group normality and that
the within group variance is the same across groups.
}
\examples{
## -- simulate the data
mu = 0; sigma2 = 10; tau2 = 1; p =100; 
theta = rnorm(p,mu,sqrt(tau2))
ns = round(runif(p,2,18))
Y=c()
for(i in 1:p){
 d2 = rnorm(ns[i],theta[i],sqrt(sigma2))
 d1 = rep(i,ns[i])
 d = cbind(d1,d2)
 Y = rbind(Y,d)}
y = Y[,2]
g = Y[,1]

## -- FAB t-intervals
FCI = multifabCIhom(y,g)  

## -- UMAU t-intervals 
ybar<-tapply(y,g,mean) ; ssd<-tapply(y,g,sd) ; n<-table(g) 
qtn<-cbind( qt(.025,n-1),  qt(.975,n-1) ) 
UCI<-sweep(sweep(qtn,1,ssd/sqrt(n),"*"),1,ybar,"+") 

mean( (UCI[,2]-UCI[,1])/(FCI[,2]-FCI[,1]) , na.rm=TRUE)


}
\author{
Chaoyu Yu
}
\keyword{htest}
