% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/excess_plot.R
\name{excess_plot}
\alias{excess_plot}
\title{Plot results from fitted excess count model}
\usage{
excess_plot(fit, title = "", ylim = NULL, show.data = TRUE, alpha = 0.05)
}
\arguments{
\item{fit}{The output from `excess_model`}

\item{title}{A title to add to plot}

\item{ylim}{A vector with two numbers that determines the kimits for the y-axis}

\item{show.data}{A logical that determines if the observed percent changes are shown}

\item{alpha}{1 - `alpha` confidence intervals are shown}
}
\value{
An ggplot object containing the plot.
}
\description{
Plot results from fitted excess count model
}
\examples{
data(new_jersey_counts)
exclude_dates <- as.Date("2012-10-29") + 0:180
control_dates <- seq(min(new_jersey_counts$date), min(exclude_dates) - 1, by = "day")
f <- excess_model(new_jersey_counts,
start = as.Date("2012-09-01"), 
end = as.Date("2013-09-01"), 
exclude = exclude_dates,
model = "correlated",
weekday.effect = TRUE,
control.dates = control_dates)

library(ggplot2)
excess_plot(f)

}
