% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitWtErgmTerm.R
\name{CMP-ergmTerm}
\alias{CMP-ergmTerm}
\alias{InitWtErgmTerm.CMP}
\title{Conway-Maxwell-Poisson Distribution}
\usage{
# valued: CMP
}
\description{
This term adds one statistic to the model, of the form
\eqn{\sum_{i,j}\log(y_{i,j}!)} . This turns a Poisson- or a
geometric-reference ERGM into a Conway-Maxwell-Poisson-reference
ERGM, allowing it to represent a broad range of disperson
values. In particular, combined with a Poisson-reference ERGM, a
negative coefficient on this term induces underdispersion and a
positive coefficient induces overdispersion. (This behavior is
different from 3.1.1, when the negation of this value was used.)
}
\details{
Note that its current implementation may not perform well if the
data are overdispersed relative to geometric.
}
\seealso{
\code{\link[ergm:ergmTerm]{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "CMP", "subsection")}
}
\concept{directed}
\concept{nonnegative}
\concept{undirected}
