% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equation.R
\name{equation}
\alias{equation}
\alias{equation.default}
\alias{equation.character}
\alias{eq__}
\alias{eq_}
\alias{print.inline_equation}
\title{Get a 'LaTeX' equation from a model or from 'LaTeX' code in a R Markdown or Quarto document}
\usage{
equation(object, ...)

\method{equation}{default}(
  object,
  auto.labs = TRUE,
  origdata = NULL,
  labs = NULL,
  swap_var_names = NULL,
  ...
)

\method{equation}{character}(object, ...)

eq__(object, ...)

eq_(object, ...)

\method{print}{inline_equation}(x, ...)
}
\arguments{
\item{object}{An object with a model whose the equation is constructed. If a
\strong{character} object is provided, it is concatenated into a single
character string and the \strong{equation} class, otherwise it is not
transformed (it is supposed to be a valid 'LaTeX' equation). Remember that
backslashes must be doubled in regular R strings, or use the \code{r"(...)"}
notation, which may be more comfortable here, see examples.}

\item{...}{Further parameters passed to \code{\link[=extract_eq]{extract_eq()}}.}

\item{auto.labs}{If \code{TRUE} (by default), use labels (and units) automatically
from data or \verb{origdata=}.}

\item{origdata}{The original data set this model was fitted to. By default it
is \code{NULL} and no label is used.}

\item{labs}{Labels to change the names of elements in the \code{term} column of
the table. By default it is \code{NULL} and no term is changed.}

\item{swap_var_names}{Change the variable names for these values, regardless
of the values in \verb{auto.labs=} or \verb{labs=} that are ignored if this argument
is used. Provide a named character string with name being the variables and
strings the new names. You can use \code{^} or \verb{_} to indicate next character,
or next integer should be super- or subscript in the equation.}

\item{x}{An \strong{inline_equation} object generated by \code{eq_()} or \code{eq__()}.}
}
\value{
An object of class \code{c("equation", "character")}.
}
\description{
Extract or create a 'LaTeX' equation to describe a model, or directly from
'LaTeX' code. All objects supported by \code{\link[=extract_eq]{extract_eq()}} are also supported by
the default method description. If labels (and units) are defined as
attributes to the data, they are automatically used in the equation in place
of the variable names.
}
\details{
There are slight differences between \code{equation()}, \code{eq_()} and \code{eq__()}:
\itemize{
\item \code{equation()} returns a string with 'LaTeX' code and prints 'LaTeX' code at
the R console.
\item \code{eq_()} returns the 'LaTeX' code surrounded by a dollar sign \verb{$...$} and is
suitable to build inline equations in R Markdown/Quarto documents by using
inline R code. It prints the rendered inline equation in the RStudio
Viewer or in the browser. So it is advised to rapidly preview the
resulting equation.
\item \code{eq__()} returns the 'LaTeX' code \emph{not} surrounded by dollar signs in a
single character string. It also prints the rendered inline equation in
the RStudio Viewer or in the browser.
It should be used in an R inline chunk inside a \verb{$$...$$}
construct in a Markdown text. The result is a display equation that can
also be cross referenced in Quarto in the usual way if you label it, e.g.,
you use \verb{$$...$$ \{#eq-label\}}.
}
}
\examples{
iris_lm <- lm(data = iris, Petal.Length ~ Sepal.Length + Species)
summary(iris_lm)
equation(iris_lm)
# Providing directly the LaTeX code of the equation (variance of a sample)
equation("S^2_y = \\\\sum_{i=1}^{n-1} \\\\frac{(y_i - \\\\bar{Y})^2}{n}")
# Easier to write like this (avoiding the double backslashes):
eq1 <- equation(r"(S^2_y = \sum_{i=1}^{n-1} \frac{(y_i - \bar{Y})^2}{n})")
# Print raw text:
eq1
# Get a preview of the equation
if (interactive())
  eq__(eq1)
# The same function can be used inside a `$$...$$ {#eq-label}` construct in
# R Markdown or Quarto to calcule a display equation that is also recognized
# by the cross referencing system of Quarto.
# Get a string suitable for inclusion inline in R Markdown with `r eq__(eq1)`
# (inside Markdown text and without the dollar signs around it)
# For inline equations in a Markdown text, you are better to use `r eq_(eq1)`
if (interactive())
  eq_(eq1)
}
