% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_cfr.R
\name{add_mr}
\alias{add_mr}
\title{Add mortality rate statistics to a gtsummary table}
\usage{
add_mr(
  gts_object,
  deaths_var,
  population = NULL,
  multiplier = 10^4,
  drop_tblsummary_stat = FALSE
)
}
\arguments{
\item{gts_object}{A gtsummary object created with functions such as
\code{gtsummary::tbl_summary()} or \code{gtsummary::tbl_cross()}.}

\item{deaths_var}{A logical variable name in the data indicating death
status (e.g. \code{TRUE} for death).}

\item{population}{Optional numeric vector giving the population size for
the denominator. If \code{NULL}, the population is inferred from the data.}

\item{multiplier}{Numeric multiplier used to scale the mortality rate
(e.g. \code{1} = proportion, \code{100} = percent, \code{10^4} = per 10,000).}

\item{drop_tblsummary_stat}{Logical; if \code{TRUE}, removes the original
\code{tbl_summary} statistic column (default = \code{FALSE}).}
}
\value{
A modified gtsummary object with additional columns showing
the number of deaths, population, mortality rate, and 95\% confidence
interval.
}
\description{
This function wraps \code{gtsummary::add_stat()} to calculate and display
\strong{mortality rates} (deaths per given population multiplier) with 95\%
confidence intervals, using the \code{epitabulate::mortality_rate()} function
internally.
}
