% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normal_quadra.R
\name{normal_quadra}
\alias{normal_quadra}
\title{Gaussian Quadrature Points and Weights}
\usage{
normal_quadra(n, mm)
}
\arguments{
\item{n}{Integer. Number of quadrature points (must be >= 2).}

\item{mm}{Numeric. Positive value giving the maximum absolute value of the
quadrature nodes (range will be from -mm to +mm).}
}
\value{
A list with:
\describe{
\item{nodes}{Quadrature nodes from -mm to +mm.}
\item{weights}{Normalized weights proportional to the standard normal
density at each node.}
}
}
\description{
Generate Gaussian quadrature points and corresponding normalized weights
based on the standard normal density over a symmetric interval.
}
\examples{
normal_quadra(41, 5)
}
