% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plot.R
\name{plot_evolution}
\alias{plot_evolution}
\title{Plot the evolution of the mean and the best value of the population used by the GeneticAlgorithm}
\usage{
plot_evolution(
  list,
  mean_color = "#F2A900",
  best_color = "#008080",
  xlab = "Epochs",
  ylab = "Score"
)
}
\arguments{
\item{list}{A list with 2 elements returned by the GeneticAlgorithm: "mean" and "best", containing the numeric vectors representing the mean and best fitness of the population}

\item{mean_color}{A string specifying the color of the mean values}

\item{best_color}{A string specifying the color of the best values}

\item{xlab}{A string specifying the label for the x-axis}

\item{ylab}{A string specifying the label for the y-axis}
}
\value{
no returned value, should plot the evolution of the genetic algorithm
results (mean/max score for each epoch).
}
\description{
Plot the evolution of the mean and the best value of the population used by the GeneticAlgorithm
}
\examples{
\donttest{
data("ATC_Tree_UpperBound_2024")
data("FAERS_myopathy")

results = GeneticAlgorithm(epochs = 10, nbIndividuals = 10, 
            ATCtree = ATC_Tree_UpperBound_2024,
            observations = FAERS_myopathy)

plot_evolution(list = results)
}
}
