% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{computeMetrics_size2}
\alias{computeMetrics_size2}
\title{Function used in the reference article to compare diverse Disproportionality Analysis metrics}
\usage{
computeMetrics_size2(CocktailList, ATCtree, observations, num_thread = 1L)
}
\arguments{
\item{CocktailList}{: A list of cocktails on which the Disproportionality analysis metrics should be computed}

\item{ATCtree}{: ATC tree with upper bound of the DFS (without the root)}

\item{observations}{: observation of the AE based on the medications of each patients
(a DataFrame containing the medication on the first column and the ADR (boolean) on the second)
on which we want to compute the risk distribution}

\item{num_thread}{: Number of thread to run in parallel if openMP is available, 1 by default}
}
\value{
Multiple DA metrics computed on CocktailList cocktails
}
\description{
Function used in the reference article to compare diverse Disproportionality Analysis metrics
}
\examples{
\donttest{
data("ATC_Tree_UpperBound_2024")
data("FAERS_myopathy")

cocktails = list(c(561, 904),
               c(1902, 4585)) # only size 2 cocktails allowed for this function

scores_of_cocktails = computeMetrics_size2(CocktailList = cocktails,
                              ATCtree = ATC_Tree_UpperBound_2024, 
                              observations = FAERS_myopathy[1:100,])
}
}
