% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StatisticalTests.R
\name{calculate_divergence}
\alias{calculate_divergence}
\title{Calculate the divergence between 2 distributions (the true Distribution and the learned one)}
\usage{
calculate_divergence(
  empirical_distribution,
  true_distribution,
  method = "TV",
  Filtered = FALSE
)
}
\arguments{
\item{empirical_distribution}{A numeric vector of values representing the empirical distribution (return value of DistributionAproximation function)}

\item{true_distribution}{A numeric vector of values representing the true distribution computed by the trueDistributionSizeTwoCocktail function}

\item{method}{A string, either "TV" or "KL" to respectively use the total variation distance or the Kullback-Leibler divergence. (default = "TV")}

\item{Filtered}{Should we use the filtered distribution or the normal one}
}
\value{
A numeric value representing the divergence of the 2 distributions
}
\description{
Calculate the divergence between 2 distributions (the true Distribution and the learned one)
}
\examples{
\donttest{
data("ATC_Tree_UpperBound_2024")
data("FAERS_myopathy")

estimated_score_distribution = DistributionApproximation(epochs = 10,
            ATCtree = ATC_Tree_UpperBound_2024,
            observations = FAERS_myopathy[1:100,], Smax =2)
            
true_score_distribution = trueDistributionSizeTwoCocktail(ATCtree = ATC_Tree_UpperBound_2024,
            observations = FAERS_myopathy[1:100,], beta = 4)

divergence <- calculate_divergence(empirical_distribution = estimated_score_distribution,
                true_distribution = true_score_distribution)
}
}
