% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/candidate_add_infor.R
\name{candidate_add_infor}
\alias{candidate_add_infor}
\title{Downloads data on the candidates - Addtional information}
\usage{
candidate_add_infor(
  year,
  uf = "all",
  br_archive = FALSE,
  encoding = "latin1",
  temp = TRUE,
  readme_pdf = FALSE
)
}
\arguments{
\item{year}{Election year (\code{integer}). For this function, only the years 2024
are available.}

\item{uf}{Federation Unit acronym (\code{character vector}).}

\item{br_archive}{In the TSE's data repository, some results can be obtained for the whole country by loading a single
within a single file by setting this argument to \code{TRUE} (may not work in for some elections and, in 
other, it recovers only electoral data for presidential elections, absent in other files).}

\item{encoding}{Data original encoding (defaults to 'latin1'). This can be changed to avoid errors
when \code{ascii = TRUE}.}

\item{temp}{(\code{logical}). temp}

\item{readme_pdf}{original readme}
}
\value{
\code{candidate_add_infor} returns a \code{tbl, data.frame} with the following variables:
}
\description{
\code{candidate_add_infor()} downloads and aggregates data on the candidates' background who ran in
elections in Brazil. The function returns a \code{data.frame} where each observation
corresponds to a candidate.
}
\details{
If export is set to \code{TRUE}, the downloaded data is saved as .dta and .sav
 files in the current directory.
}
\note{
For the elections prior to 2024.
}
\examples{
\dontrun{
df <- candidate_add_infor(2024)
}
}
