% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tune_esn.R
\name{tune_esn}
\alias{tune_esn}
\title{Tune hyperparameters of an Echo State Network}
\usage{
tune_esn(
  y,
  n_ahead = 12,
  n_split = 5,
  alpha = seq(0.1, 1, by = 0.1),
  rho = seq(0.1, 1, by = 0.1),
  tau = c(0.1, 0.2, 0.4),
  min_train = NULL,
  ...
)
}
\arguments{
\item{y}{Numeric vector containing the response variable (no missing values).}

\item{n_ahead}{Integer value. The number of periods for forecasting (i.e. forecast horizon).}

\item{n_split}{Integer value. The number of rolling train/test splits.}

\item{alpha}{Numeric vector. The candidate leakage rates (smoothing parameters).}

\item{rho}{Numeric vector. The candidate spectral radii.}

\item{tau}{Numeric vector. The candidate reservoir scaling values.}

\item{min_train}{Integer value. Minimum training sample size for the first split.}

\item{...}{Further arguments passed to \code{train_esn()} (except \code{alpha}, \code{rho}, and \code{tau}, which are set by the tuning grid).}
}
\value{
An object of class \code{"tune_esn"} (a list) with:
  \itemize{
     \item \code{pars}: A \code{tibble} with one row per hyperparameter combination and split. Columns include
           \code{alpha}, \code{rho}, \code{tau}, \code{split}, \code{train_start}, \code{train_end}, \code{test_start},
           \code{test_end}, \code{mse}, \code{mae}, and \code{id}.
     \item \code{fcst}: A numeric matrix of point forecasts with \code{nrow(fcst) == nrow(pars)} and
           \code{ncol(fcst) == n_ahead}.
     \item \code{actual}: The original input series \code{y} (numeric vector), returned for convenience.
}
}
\description{
Tune hyperparameters of an Echo State Network (ESN) based on 
   time series cross-validation (i.e., rolling forecast). The input series is 
   split into \code{n_split} expanding-window train/test sets with test size 
   \code{n_ahead}. For each split and each hyperparameter combination 
   (\code{alpha, rho, tau}) an ESN is trained via \code{train_esn()} and 
   forecasts are generated via \code{forecast_esn()}.
}
\examples{
xdata <- as.numeric(AirPassengers)
fit <- tune_esn(
  y = xdata,
  n_ahead = 12,
  n_split = 5,
  alpha = c(0.5, 1),
  rho   = c(1.0),
  tau   = c(0.4),
  inf_crit = "bic"
)
summary(fit)
plot(fit)

}
\references{
\itemize{
      \item{Häußer, A. (2026). Echo State Networks for Time Series Forecasting: Hyperparameter Sweep and Benchmarking. arXiv preprint arXiv:2602.03912, 2026. \url{https://arxiv.org/abs/2602.03912}}
      \item{Jaeger, H. (2001). The “echo state” approach to analysing and training recurrent neural networks with an erratum note. Bonn, Germany: German National Research Center for Information Technology GMD Technical Report, 148(34):13.}
      \item{Jaeger, H. (2002). Tutorial on training recurrent neural networks, covering BPPT, RTRL, EKF and the "echo state network" approach.}
      \item{Lukosevicius, M. (2012). A practical guide to applying echo state networks. In Neural Networks: Tricks of the Trade: Second Edition, pages 659–686. Springer.}
      \item{Lukosevicius, M. and Jaeger, H. (2009). Reservoir computing approaches to recurrent neural network training. Computer Science Review, 3(3):127–149.}
   }
}
\seealso{
Other base functions: 
\code{\link{forecast_esn}()},
\code{\link{is.esn}()},
\code{\link{is.forecast_esn}()},
\code{\link{is.tune_esn}()},
\code{\link{plot.esn}()},
\code{\link{plot.forecast_esn}()},
\code{\link{plot.tune_esn}()},
\code{\link{print.esn}()},
\code{\link{summary.esn}()},
\code{\link{summary.tune_esn}()},
\code{\link{train_esn}()}
}
\concept{base functions}
