% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QC_info_theory.R
\name{compare_info_content_plt}
\alias{compare_info_content_plt}
\title{Information Content Comparison Plot}
\usage{
compare_info_content_plt(compare_info_content_res)
}
\arguments{
\item{compare_info_content_res}{Output from
\code{\link{compare_info_content}}.}
}
\value{
Plot of measures calculated in \code{\link{compare_info_content}}.
}
\description{
This function requires the output from \code{\link{compare_info_content}}.
It is used to visualise the amount of information loss, if any, which has
occurred in a merging procedure between two discrete variables.
}
\details{
If the mutual information content between an input variable and the
  composite variable is equal to the information content of the input
  variable, it is confirmed that all information in the input variable has
  been incorporated into the composite variable.
}
\examples{
data(example_data)
require(dplyr)
require(magrittr)
example_data \%>\%
   mutate(diabetes_merged = coalesce(diabetes_type, diabetes)) \%>\%
   select(starts_with("diabetes")) ->
   merged_data

compare_info_content(merged_data$diabetes,
                     merged_data$diabetes_type,
                     merged_data$diabetes_merged) \%>\%
                     compare_info_content_plt()
}
\seealso{
\code{\link{compare_info_content}}
}
