% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtms_risk.R
\name{dtms_risk}
\alias{dtms_risk}
\title{Calculate the lifetime risk of ever reaching a state}
\usage{
dtms_risk(
  probs = NULL,
  matrix = NULL,
  risk,
  dtms,
  start_distr = NULL,
  start_state = NULL,
  start_time = NULL,
  end_time = NULL
)
}
\arguments{
\item{probs}{Data frame with transition probabilities, as created with \code{dtms_transitions}.}

\item{matrix}{Matrix with transition probabilities, as generated with \code{dtms_matrix}.}

\item{risk}{Character, name of state(s) for which risk is of interest.}

\item{dtms}{dtms object, as created with \code{dtms}.}

\item{start_distr}{Numeric (optional), distribution of starting states. If specified, average distribution over all starting states will be calculated.}

\item{start_state}{Character (optional), name of starting states. If NULL (default) all transient states will be used.}

\item{start_time}{Numeric (optional), value of time scale for start. If NULL (default) first value of time scale will be used.}

\item{end_time}{Numeric (optional), last value of time scale to consider. If NULL (default) all values of time scale starting from start_time will be used.}
}
\value{
Probability of ever reaching state `risk`.
}
\description{
The function `dtms_risk` calculates the (partial) lifetime risk of ever
reaching a state specified with the argument `risk`.
}
\examples{
## Define model: Absorbing and transient states, time scale
simple <- dtms(transient=c("A","B"),
               absorbing="X",
               timescale=0:20)
## Reshape to transition format
estdata <- dtms_format(data=simpledata,
                       dtms=simple,
                       idvar="id",
                       timevar="time",
                       statevar="state")
## Clean
estdata <- dtms_clean(data=estdata,
                      dtms=simple)
# Fit model
fit <- dtms_fit(data=estdata)
## Predict probabilities
probs    <- dtms_transitions(dtms=simple,
                             model = fit)
## Get starting distribution
S <- dtms_start(dtms=simple,
                data=estdata)
## Lifetime risk
dtms_risk(dtms=simple,
          probs=probs,
          risk="A")
}
