#-------------------------------------------------------------------------------
# Copyright (c) 2019-2022 University of Newcastle upon Tyne. All rights reserved.
# Copyright (c) 2022-2025 Arjuna Technologies, Newcastle upon Tyne. All rights reserved.
#
# This program and the accompanying materials
# are made available under the terms of the GNU Public License v3.0.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#-------------------------------------------------------------------------------

#
# Set up
#

# context("TESTING::datachk::setup")

connect.all.datasets()

test_that("setup", {
    ds_expect_variables(c("D"))
})

#
# Tests
#

# context("TESTING::datachk")
test_that("Check TESTING dataset", {
    res.class <- ds.class(x='D')
    expect_length(res.class, 3)
    expect_gte(length(res.class$study1), 1)
    expect_true("data.frame" %in% res.class$study1)
    expect_gte(length(res.class$study2), 1)
    expect_true("data.frame" %in% res.class$study2)
    expect_gte(length(res.class$study3), 1)
    expect_true("data.frame" %in% res.class$study3)

    res.length <- ds.length(x='D')
    expect_length(res.length, 4)
    expect_length(res.length$`length of D in study1`, 1)
    expect_equal(res.length$`length of D in study1`, 18)
    expect_length(res.length$`length of D in study2`, 1)
    expect_equal(res.length$`length of D in study2`, 18)
    expect_length(res.length$`length of D in study3`, 1)
    expect_equal(res.length$`length of D in study3`, 18)
    expect_equal(res.length$`total length of D in all studies combined`, 54)

    res.colnames <- ds.colnames(x='D')
    expect_length(res.colnames, 3)
    expect_length(res.colnames$study1, 18)
    expect_equal(res.colnames$study1, c("CHARACTER", "LOGICAL", "NA_VALUES", "INTEGER", "NULL_VALUES", "NON_NEGATIVE_INTEGER", "POSITIVE_INTEGER", "NEGATIVE_INTEGER", "NUMERIC", "NON_NEGATIVE_NUMERIC", "POSITIVE_NUMERIC", "NEGATIVE_NUMERIC", "FACTOR_CHARACTER", "FACTOR_INTEGER", "IDENTIFIER", "CATEGORY", "NUMERIC_ONE_CHANGE", "INTEGER_ONE_CHANGE"))
    expect_length(res.colnames$study2, 18)
    expect_equal(res.colnames$study2, c("CHARACTER", "LOGICAL", "NA_VALUES", "INTEGER", "NULL_VALUES", "NON_NEGATIVE_INTEGER", "POSITIVE_INTEGER", "NEGATIVE_INTEGER", "NUMERIC", "NON_NEGATIVE_NUMERIC", "POSITIVE_NUMERIC", "NEGATIVE_NUMERIC", "FACTOR_CHARACTER", "FACTOR_INTEGER", "IDENTIFIER", "CATEGORY", "NUMERIC_ONE_CHANGE", "INTEGER_ONE_CHANGE"))
    expect_length(res.colnames$study3, 18)
    expect_equal(res.colnames$study3, c("CHARACTER", "LOGICAL", "NA_VALUES", "INTEGER", "NULL_VALUES", "NON_NEGATIVE_INTEGER", "POSITIVE_INTEGER", "NEGATIVE_INTEGER", "NUMERIC", "NON_NEGATIVE_NUMERIC", "POSITIVE_NUMERIC", "NEGATIVE_NUMERIC", "FACTOR_CHARACTER", "FACTOR_INTEGER", "IDENTIFIER", "CATEGORY", "NUMERIC_ONE_CHANGE", "INTEGER_ONE_CHANGE"))

    res.class.character <- ds.class(x='D$CHARACTER')
    expect_length(res.class.character, 3)
    expect_length(res.class.character$study1, 1)
    expect_equal(res.class.character$study1, "character")
    expect_length(res.class.character$study2, 1)
    expect_equal(res.class.character$study2, "character")
    expect_length(res.class.character$study3, 1)
    expect_equal(res.class.character$study3, "character")

    res.length.character <- ds.length(x='D$CHARACTER')
    expect_length(res.length.character, 4)
    expect_length(res.length.character$`length of D$CHARACTER in study1`, 1)
    expect_equal(res.length.character$`length of D$CHARACTER in study1`, 71)
    expect_length(res.length.character$`length of D$CHARACTER in study2`, 1)
    expect_equal(res.length.character$`length of D$CHARACTER in study2`, 71)
    expect_length(res.length.character$`length of D$CHARACTER in study3`, 1)
    expect_equal(res.length.character$`length of D$CHARACTER in study3`, 71)
    expect_length(res.length.character$`total length of D$CHARACTER in all studies combined`, 1)
    expect_equal(res.length.character$`total length of D$CHARACTER in all studies combined`, 213)

    res.class.logical <- ds.class(x='D$LOGICAL')
    expect_length(res.class.logical, 3)
    expect_length(res.class.logical$study1, 1)
    expect_equal(res.class.logical$study1, "logical")
    expect_length(res.class.logical$study2, 1)
    expect_equal(res.class.logical$study2, "logical")
    expect_length(res.class.logical$study3, 1)
    expect_equal(res.class.logical$study3, "logical")

    res.length.logical <- ds.length(x='D$LOGICAL')
    expect_length(res.length.logical, 4)
    expect_length(res.length.logical$`length of D$LOGICAL in study1`, 1)
    expect_equal(res.length.logical$`length of D$LOGICAL in study1`, 71)
    expect_length(res.length.logical$`length of D$LOGICAL in study2`, 1)
    expect_equal(res.length.logical$`length of D$LOGICAL in study2`, 71)
    expect_length(res.length.logical$`length of D$LOGICAL in study3`, 1)
    expect_equal(res.length.logical$`length of D$LOGICAL in study3`, 71)
    expect_length(res.length.logical$`total length of D$LOGICAL in all studies combined`, 1)
    expect_equal(res.length.logical$`total length of D$LOGICAL in all studies combined`, 213)

    res.classna_values <- ds.class(x='D$NA_VALUES')
    expect_length(res.classna_values, 3)
    expect_length(res.classna_values$study1, 1)
    expect_equal(res.classna_values$study1, "character")
    expect_length(res.classna_values$study2, 1)
    expect_equal(res.classna_values$study2, "character")
    expect_length(res.classna_values$study3, 1)
    expect_equal(res.classna_values$study3, "character")

    res.lengthna_values <- ds.length(x='D$NA_VALUES')
    expect_length(res.lengthna_values, 4)
    expect_length(res.lengthna_values$`length of D$NA_VALUES in study1`, 1)
    expect_equal(res.lengthna_values$`length of D$NA_VALUES in study1`, 71)
    expect_length(res.lengthna_values$`length of D$NA_VALUES in study2`, 1)
    expect_equal(res.lengthna_values$`length of D$NA_VALUES in study2`, 71)
    expect_length(res.lengthna_values$`length of D$NA_VALUES in study3`, 1)
    expect_equal(res.lengthna_values$`length of D$NA_VALUES in study3`, 71)
    expect_length(res.lengthna_values$`total length of D$NA_VALUES in all studies combined`, 1)
    expect_equal(res.lengthna_values$`total length of D$NA_VALUES in all studies combined`, 213)

    res.class.integer <- ds.class(x='D$INTEGER')
    expect_length(res.class.integer, 3)
    expect_length(res.class.integer$study1, 1)
    expect_equal(res.class.integer$study1, "integer")
    expect_length(res.class.integer$study2, 1)
    expect_equal(res.class.integer$study2, "integer")
    expect_length(res.class.integer$study3, 1)
    expect_equal(res.class.integer$study3, "integer")

    res.length.integer <- ds.length(x='D$INTEGER')
    expect_length(res.length.integer, 4)
    expect_length(res.length.integer$`length of D$INTEGER in study1`, 1)
    expect_equal(res.length.integer$`length of D$INTEGER in study1`, 71)
    expect_length(res.length.integer$`length of D$INTEGER in study2`, 1)
    expect_equal(res.length.integer$`length of D$INTEGER in study2`, 71)
    expect_length(res.length.integer$`length of D$INTEGER in study3`, 1)
    expect_equal(res.length.integer$`length of D$INTEGER in study3`, 71)
    expect_length(res.length.integer$`total length of D$INTEGER in all studies combined`, 1)
    expect_equal(res.length.integer$`total length of D$INTEGER in all studies combined`, 213)

    res.class.null_values <- ds.class(x='D$NULL_VALUES')
    expect_length(res.class.null_values, 3)
    expect_length(res.class.null_values$study1, 1)
    expect_equal(res.class.null_values$study1, "character")
    expect_length(res.class.null_values$study2, 1)
    expect_equal(res.class.null_values$study2, "character")
    expect_length(res.class.null_values$study3, 1)
    expect_equal(res.class.null_values$study3, "character")

    res.length.null_values <- ds.length(x='D$NULL_VALUES')
    expect_length(res.length.null_values, 4)
    expect_length(res.length.null_values$`length of D$NULL_VALUES in study1`, 1)
    expect_equal(res.length.null_values$`length of D$NULL_VALUES in study1`, 71)
    expect_length(res.length.null_values$`length of D$NULL_VALUES in study2`, 1)
    expect_equal(res.length.null_values$`length of D$NULL_VALUES in study2`, 71)
    expect_length(res.length.null_values$`length of D$NULL_VALUES in study3`, 1)
    expect_equal(res.length.null_values$`length of D$NULL_VALUES in study3`, 71)
    expect_length(res.length.null_values$`total length of D$NULL_VALUES in all studies combined`, 1)
    expect_equal(res.length.null_values$`total length of D$NULL_VALUES in all studies combined`, 213)

    res.class.non_negative_integer <- ds.class(x='D$NON_NEGATIVE_INTEGER')
    expect_length(res.class.non_negative_integer, 3)
    expect_length(res.class.non_negative_integer$study1, 1)
    expect_equal(res.class.non_negative_integer$study1, "integer")
    expect_length(res.class.non_negative_integer$study2, 1)
    expect_equal(res.class.non_negative_integer$study2, "integer")
    expect_length(res.class.non_negative_integer$study3, 1)
    expect_equal(res.class.non_negative_integer$study3, "integer")

    res.length.non_negative_integer <- ds.length(x='D$NON_NEGATIVE_INTEGER')
    expect_length(res.length.non_negative_integer, 4)
    expect_length(res.length.non_negative_integer$`length of D$NON_NEGATIVE_INTEGER in study1`, 1)
    expect_equal(res.length.non_negative_integer$`length of D$NON_NEGATIVE_INTEGER in study1`, 71)
    expect_length(res.length.non_negative_integer$`length of D$NON_NEGATIVE_INTEGER in study2`, 1)
    expect_equal(res.length.non_negative_integer$`length of D$NON_NEGATIVE_INTEGER in study2`, 71)
    expect_length(res.length.non_negative_integer$`length of D$NON_NEGATIVE_INTEGER in study3`, 1)
    expect_equal(res.length.non_negative_integer$`length of D$NON_NEGATIVE_INTEGER in study3`, 71)
    expect_length(res.length.non_negative_integer$`total length of D$NON_NEGATIVE_INTEGER in all studies combined`, 1)
    expect_equal(res.length.non_negative_integer$`total length of D$NON_NEGATIVE_INTEGER in all studies combined`, 213)

    res.class.positive_integer <- ds.class(x='D$POSITIVE_INTEGER')
    expect_length(res.class.positive_integer, 3)
    expect_length(res.class.positive_integer$study1, 1)
    expect_equal(res.class.positive_integer$study1, "integer")
    expect_length(res.class.positive_integer$study2, 1)
    expect_equal(res.class.positive_integer$study2, "integer")
    expect_length(res.class.positive_integer$study3, 1)
    expect_equal(res.class.positive_integer$study3, "integer")

    res.length.positive_integer <- ds.length(x='D$POSITIVE_INTEGER')
    expect_length(res.length.positive_integer, 4)
    expect_length(res.length.positive_integer$`length of D$POSITIVE_INTEGER in study1`, 1)
    expect_equal(res.length.positive_integer$`length of D$POSITIVE_INTEGER in study1`, 71)
    expect_length(res.length.positive_integer$`length of D$POSITIVE_INTEGER in study2`, 1)
    expect_equal(res.length.positive_integer$`length of D$POSITIVE_INTEGER in study2`, 71)
    expect_length(res.length.positive_integer$`length of D$POSITIVE_INTEGER in study3`, 1)
    expect_equal(res.length.positive_integer$`length of D$POSITIVE_INTEGER in study3`, 71)
    expect_length(res.length.positive_integer$`total length of D$POSITIVE_INTEGER in all studies combined`, 1)
    expect_equal(res.length.positive_integer$`total length of D$POSITIVE_INTEGER in all studies combined`, 213)

    res.class.negative_integer <- ds.class(x='D$NEGATIVE_INTEGER')
    expect_length(res.class.negative_integer, 3)
    expect_length(res.class.negative_integer$study1, 1)
    expect_equal(res.class.negative_integer$study1, "integer")
    expect_length(res.class.negative_integer$study2, 1)
    expect_equal(res.class.negative_integer$study2, "integer")
    expect_length(res.class.negative_integer$study3, 1)
    expect_equal(res.class.negative_integer$study3, "integer")

    res.length.negative_integer <- ds.length(x='D$NEGATIVE_INTEGER')
    expect_length(res.length.negative_integer, 4)
    expect_length(res.length.negative_integer$`length of D$NEGATIVE_INTEGER in study1`, 1)
    expect_equal(res.length.negative_integer$`length of D$NEGATIVE_INTEGER in study1`, 71)
    expect_length(res.length.negative_integer$`length of D$NEGATIVE_INTEGER in study2`, 1)
    expect_equal(res.length.negative_integer$`length of D$NEGATIVE_INTEGER in study2`, 71)
    expect_length(res.length.negative_integer$`length of D$NEGATIVE_INTEGER in study3`, 1)
    expect_equal(res.length.negative_integer$`length of D$NEGATIVE_INTEGER in study3`, 71)
    expect_length(res.length.negative_integer$`total length of D$NEGATIVE_INTEGER in all studies combined`, 1)
    expect_equal(res.length.negative_integer$`total length of D$NEGATIVE_INTEGER in all studies combined`, 213)

    res.class.numeric <- ds.class(x='D$NUMERIC')
    expect_length(res.class.numeric, 3)
    expect_length(res.class.numeric$study1, 1)
    expect_equal(res.class.numeric$study1, "numeric")
    expect_length(res.class.numeric$study2, 1)
    expect_equal(res.class.numeric$study2, "numeric")
    expect_length(res.class.numeric$study3, 1)
    expect_equal(res.class.numeric$study3, "numeric")

    res.length.numeric <- ds.length(x='D$NUMERIC')
    expect_length(res.length.numeric, 4)
    expect_length(res.length.numeric$`length of D$NUMERIC in study1`, 1)
    expect_equal(res.length.numeric$`length of D$NUMERIC in study1`, 71)
    expect_length(res.length.numeric$`length of D$NUMERIC in study2`, 1)
    expect_equal(res.length.numeric$`length of D$NUMERIC in study2`, 71)
    expect_length(res.length.numeric$`length of D$NUMERIC in study3`, 1)
    expect_equal(res.length.numeric$`length of D$NUMERIC in study3`, 71)
    expect_length(res.length.numeric$`total length of D$NUMERIC in all studies combined`, 1)
    expect_equal(res.length.numeric$`total length of D$NUMERIC in all studies combined`, 213)

    res.class.non_negative_numeric <- ds.class(x='D$NON_NEGATIVE_NUMERIC')
    expect_length(res.class.non_negative_numeric, 3)
    expect_length(res.class.non_negative_numeric$study1, 1)
    expect_equal(res.class.non_negative_numeric$study1, "numeric")
    expect_length(res.class.non_negative_numeric$study2, 1)
    expect_equal(res.class.non_negative_numeric$study2, "numeric")
    expect_length(res.class.non_negative_numeric$study3, 1)
    expect_equal(res.class.non_negative_numeric$study3, "numeric")

    res.length.non_negative_numeric <- ds.length(x='D$NON_NEGATIVE_NUMERIC')
    expect_length(res.length.non_negative_numeric, 4)
    expect_length(res.length.non_negative_numeric$`length of D$NON_NEGATIVE_NUMERIC in study1`, 1)
    expect_equal(res.length.non_negative_numeric$`length of D$NON_NEGATIVE_NUMERIC in study1`, 71)
    expect_length(res.length.non_negative_numeric$`length of D$NON_NEGATIVE_NUMERIC in study2`, 1)
    expect_equal(res.length.non_negative_numeric$`length of D$NON_NEGATIVE_NUMERIC in study2`, 71)
    expect_length(res.length.non_negative_numeric$`length of D$NON_NEGATIVE_NUMERIC in study3`, 1)
    expect_equal(res.length.non_negative_numeric$`length of D$NON_NEGATIVE_NUMERIC in study3`, 71)
    expect_length(res.length.non_negative_numeric$`total length of D$NON_NEGATIVE_NUMERIC in all studies combined`, 1)
    expect_equal(res.length.non_negative_numeric$`total length of D$NON_NEGATIVE_NUMERIC in all studies combined`, 213)

    res.class.positive_numeric <- ds.class(x='D$POSITIVE_NUMERIC')
    expect_length(res.class.positive_numeric, 3)
    expect_length(res.class.positive_numeric$study1, 1)
    expect_equal(res.class.positive_numeric$study1, "numeric")
    expect_length(res.class.positive_numeric$study2, 1)
    expect_equal(res.class.positive_numeric$study2, "numeric")
    expect_length(res.class.positive_numeric$study3, 1)
    expect_equal(res.class.positive_numeric$study3, "numeric")

    res.length.positive_numeric <- ds.length(x='D$POSITIVE_NUMERIC')
    expect_length(res.length.positive_numeric, 4)
    expect_length(res.length.positive_numeric$`length of D$POSITIVE_NUMERIC in study1`, 1)
    expect_equal(res.length.positive_numeric$`length of D$POSITIVE_NUMERIC in study1`, 71)
    expect_length(res.length.positive_numeric$`length of D$POSITIVE_NUMERIC in study2`, 1)
    expect_equal(res.length.positive_numeric$`length of D$POSITIVE_NUMERIC in study2`, 71)
    expect_length(res.length.positive_numeric$`length of D$POSITIVE_NUMERIC in study3`, 1)
    expect_equal(res.length.positive_numeric$`length of D$POSITIVE_NUMERIC in study3`, 71)
    expect_length(res.length.positive_numeric$`total length of D$POSITIVE_NUMERIC in all studies combined`, 1)
    expect_equal(res.length.positive_numeric$`total length of D$POSITIVE_NUMERIC in all studies combined`, 213)

    res.class.negative_numeric <- ds.class(x='D$NEGATIVE_NUMERIC')
    expect_length(res.class.negative_numeric, 3)
    expect_length(res.class.negative_numeric$study1, 1)
    expect_equal(res.class.negative_numeric$study1, "numeric")
    expect_length(res.class.negative_numeric$study2, 1)
    expect_equal(res.class.negative_numeric$study2, "numeric")
    expect_length(res.class.negative_numeric$study3, 1)
    expect_equal(res.class.negative_numeric$study3, "numeric")

    res.length.negative_numeric <- ds.length(x='D$NEGATIVE_NUMERIC')
    expect_length(res.length.negative_numeric, 4)
    expect_length(res.length.negative_numeric$`length of D$NEGATIVE_NUMERIC in study1`, 1)
    expect_equal(res.length.negative_numeric$`length of D$NEGATIVE_NUMERIC in study1`, 71)
    expect_length(res.length.negative_numeric$`length of D$NEGATIVE_NUMERIC in study2`, 1)
    expect_equal(res.length.negative_numeric$`length of D$NEGATIVE_NUMERIC in study2`, 71)
    expect_length(res.length.negative_numeric$`length of D$NEGATIVE_NUMERIC in study3`, 1)
    expect_equal(res.length.negative_numeric$`length of D$NEGATIVE_NUMERIC in study3`, 71)
    expect_length(res.length.negative_numeric$`total length of D$NEGATIVE_NUMERIC in all studies combined`, 1)
    expect_equal(res.length.negative_numeric$`total length of D$NEGATIVE_NUMERIC in all studies combined`, 213)

    res.class.factor_character <- ds.class(x='D$FACTOR_CHARACTER')
    expect_length(res.class.factor_character, 3)
    expect_length(res.class.factor_character$study1, 1)
    expect_equal(res.class.factor_character$study1, "factor")
    expect_length(res.class.factor_character$study2, 1)
    expect_equal(res.class.factor_character$study2, "factor")
    expect_length(res.class.factor_character$study3, 1)
    expect_equal(res.class.factor_character$study3, "factor")

    res.length.factor_character <- ds.length(x='D$FACTOR_CHARACTER')
    expect_length(res.length.factor_character, 4)
    expect_length(res.length.factor_character$`length of D$FACTOR_CHARACTER in study1`, 1)
    expect_equal(res.length.factor_character$`length of D$FACTOR_CHARACTER in study1`, 71)
    expect_length(res.length.factor_character$`length of D$FACTOR_CHARACTER in study2`, 1)
    expect_equal(res.length.factor_character$`length of D$FACTOR_CHARACTER in study2`, 71)
    expect_length(res.length.factor_character$`length of D$FACTOR_CHARACTER in study3`, 1)
    expect_equal(res.length.factor_character$`length of D$FACTOR_CHARACTER in study3`, 71)
    expect_length(res.length.factor_character$`total length of D$FACTOR_CHARACTER in all studies combined`, 1)
    expect_equal(res.length.factor_character$`total length of D$FACTOR_CHARACTER in all studies combined`, 213)

    res.class.factor_integer <- ds.class(x='D$FACTOR_INTEGER')
    expect_length(res.class.factor_integer, 3)
    expect_length(res.class.factor_integer$study1, 1)
    expect_equal(res.class.factor_integer$study1, "factor")
    expect_length(res.class.factor_integer$study2, 1)
    expect_equal(res.class.factor_integer$study2, "factor")
    expect_length(res.class.factor_integer$study3, 1)
    expect_equal(res.class.factor_integer$study3, "factor")

    res.length.factor_integer <- ds.length(x='D$FACTOR_INTEGER')
    expect_length(res.length.factor_integer, 4)
    expect_length(res.length.factor_integer$`length of D$FACTOR_INTEGER in study1`, 1)
    expect_equal(res.length.factor_integer$`length of D$FACTOR_INTEGER in study1`, 71)
    expect_length(res.length.factor_integer$`length of D$FACTOR_INTEGER in study2`, 1)
    expect_equal(res.length.factor_integer$`length of D$FACTOR_INTEGER in study2`, 71)
    expect_length(res.length.factor_integer$`length of D$FACTOR_INTEGER in study3`, 1)
    expect_equal(res.length.factor_integer$`length of D$FACTOR_INTEGER in study3`, 71)
    expect_length(res.length.factor_integer$`total length of D$FACTOR_INTEGER in all studies combined`, 1)
    expect_equal(res.length.factor_integer$`total length of D$FACTOR_INTEGER in all studies combined`, 213)

    res.class.identifier <- ds.class(x='D$IDENTIFIER')
    expect_length(res.class.identifier, 3)
    expect_length(res.class.identifier$study1, 1)
    expect_equal(res.class.identifier$study1, "integer")
    expect_length(res.class.identifier$study2, 1)
    expect_equal(res.class.identifier$study2, "integer")
    expect_length(res.class.identifier$study3, 1)
    expect_equal(res.class.identifier$study3, "integer")

    res.length.identifier <- ds.length(x='D$IDENTIFIER')
    expect_length(res.length.identifier, 4)
    expect_length(res.length.identifier$`length of D$IDENTIFIER in study1`, 1)
    expect_equal(res.length.identifier$`length of D$IDENTIFIER in study1`, 71)
    expect_length(res.length.identifier$`length of D$IDENTIFIER in study2`, 1)
    expect_equal(res.length.identifier$`length of D$IDENTIFIER in study2`, 71)
    expect_length(res.length.identifier$`length of D$IDENTIFIER in study3`, 1)
    expect_equal(res.length.identifier$`length of D$IDENTIFIER in study3`, 71)
    expect_length(res.length.identifier$`total length of D$IDENTIFIER in all studies combined`, 1)
    expect_equal(res.length.identifier$`total length of D$IDENTIFIER in all studies combined`, 213)

    res.class.category <- ds.class(x='D$CATEGORY')
    expect_length(res.class.category, 3)
    expect_length(res.class.category$study1, 1)
    expect_equal(res.class.category$study1, "integer")
    expect_length(res.class.category$study2, 1)
    expect_equal(res.class.category$study2, "integer")
    expect_length(res.class.category$study3, 1)
    expect_equal(res.class.category$study3, "integer")

    res.length.category <- ds.length(x='D$CATEGORY')
    expect_length(res.length.category, 4)
    expect_length(res.length.category$`length of D$CATEGORY in study1`, 1)
    expect_equal(res.length.category$`length of D$CATEGORY in study1`, 71)
    expect_length(res.length.category$`length of D$CATEGORY in study2`, 1)
    expect_equal(res.length.category$`length of D$CATEGORY in study2`, 71)
    expect_length(res.length.category$`length of D$CATEGORY in study3`, 1)
    expect_equal(res.length.category$`length of D$CATEGORY in study3`, 71)
    expect_length(res.length.category$`total length of D$CATEGORY in all studies combined`, 1)
    expect_equal(res.length.category$`total length of D$CATEGORY in all studies combined`, 213)

    res.class.numeric_one_change <- ds.class(x='D$NUMERIC_ONE_CHANGE')
    expect_length(res.class.numeric_one_change, 3)
    expect_length(res.class.numeric_one_change$study1, 1)
    expect_equal(res.class.numeric_one_change$study1, "numeric")
    expect_length(res.class.numeric_one_change$study2, 1)
    expect_equal(res.class.numeric_one_change$study2, "numeric")
    expect_length(res.class.numeric_one_change$study3, 1)
    expect_equal(res.class.numeric_one_change$study3, "numeric")

    res.length.numeric_one_change <- ds.length(x='D$NUMERIC_ONE_CHANGE')
    expect_length(res.length.numeric_one_change, 4)
    expect_length(res.length.numeric_one_change$`length of D$NUMERIC_ONE_CHANGE in study1`, 1)
    expect_equal(res.length.numeric_one_change$`length of D$NUMERIC_ONE_CHANGE in study1`, 71)
    expect_length(res.length.numeric_one_change$`length of D$NUMERIC_ONE_CHANGE in study2`, 1)
    expect_equal(res.length.numeric_one_change$`length of D$NUMERIC_ONE_CHANGE in study2`, 71)
    expect_length(res.length.numeric_one_change$`length of D$NUMERIC_ONE_CHANGE in study3`, 1)
    expect_equal(res.length.numeric_one_change$`length of D$NUMERIC_ONE_CHANGE in study3`, 71)
    expect_length(res.length.numeric_one_change$`total length of D$NUMERIC_ONE_CHANGE in all studies combined`, 1)
    expect_equal(res.length.numeric_one_change$`total length of D$NUMERIC_ONE_CHANGE in all studies combined`, 213)

    res.class.integer_one_change <- ds.class(x='D$INTEGER_ONE_CHANGE')
    expect_length(res.class.integer_one_change, 3)
    expect_length(res.class.integer_one_change$study1, 1)
    expect_equal(res.class.integer_one_change$study1, "integer")
    expect_length(res.class.integer_one_change$study2, 1)
    expect_equal(res.class.integer_one_change$study2, "integer")
    expect_length(res.class.integer_one_change$study3, 1)
    expect_equal(res.class.integer_one_change$study3, "integer")

    res.length.integer_one_change <- ds.length(x='D$INTEGER_ONE_CHANGE')
    expect_length(res.length.integer_one_change, 4)
    expect_length(res.length.integer_one_change$`length of D$INTEGER_ONE_CHANGE in study1`, 1)
    expect_equal(res.length.integer_one_change$`length of D$INTEGER_ONE_CHANGE in study1`, 71)
    expect_length(res.length.integer_one_change$`length of D$INTEGER_ONE_CHANGE in study2`, 1)
    expect_equal(res.length.integer_one_change$`length of D$INTEGER_ONE_CHANGE in study2`, 71)
    expect_length(res.length.integer_one_change$`length of D$INTEGER_ONE_CHANGE in study3`, 1)
    expect_equal(res.length.integer_one_change$`length of D$INTEGER_ONE_CHANGE in study3`, 71)
    expect_length(res.length.integer_one_change$`total length of D$INTEGER_ONE_CHANGE in all studies combined`, 1)
    expect_equal(res.length.integer_one_change$`total length of D$INTEGER_ONE_CHANGE in all studies combined`, 213)
})

#
# Tear down
#

# context("TESTING::datachk::shutdown")

test_that("shutdown", {
    ds_expect_variables(c("D"))
})

disconnect.all.datasets()

# context("TESTING::datachk::done")
