% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean.data.R
\name{clean.data}
\alias{clean.data}
\title{Cleaning phylogenetic data}
\usage{
clean.data(data, tree, inc.nodes = FALSE)
}
\arguments{
\item{data}{A \code{data.frame} or \code{matrix} with the elements names as row names.}

\item{tree}{A \code{phylo} or \code{multiPhylo} object.}

\item{inc.nodes}{Logical, whether to check if the nodes in \code{tree} are also present in \code{data} (\code{TRUE}) or not (\code{FALSE}; default).}
}
\value{
A \code{list} containing the cleaned data and tree(s) and information on the eventual dropped tips and rows.
}
\description{
Cleans a table/tree to match with a given table/tree
}
\details{
Note if \code{inc.nodes} is set to \code{TRUE}, the function outputs an error message if there is no matching.
}
\examples{
##Creating a set of different trees
trees_list <- list(rtree(5, tip.label = LETTERS[1:5]), rtree(4,
     tip.label = LETTERS[1:4]), rtree(6, tip.label = LETTERS[1:6]))
class(trees_list) <- "multiPhylo"

##Creating a matrix
dummy_data <- matrix(c(rnorm(5), runif(5)), 5, 2,
    dimnames = list(LETTERS[1:5], c("var1", "var2")))

##Cleaning the trees and the data
cleaned <- clean.data(data = dummy_data, tree = trees_list)
##The taxa that where dropped (tips and rows):
c(cleaned$dropped_tips, cleaned$dropped_rows)
##The cleaned trees:
cleaned$tree
##The cleaned data set:
cleaned$data

}
\seealso{
\code{\link{tree.age}}.
}
\author{
Thomas Guillerme
}
