% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topoplots.R
\name{plot_topo_mean}
\alias{plot_topo_mean}
\title{Plot topographic map of average EEG signal}
\usage{
plot_topo_mean(
  data,
  mesh,
  coords = NULL,
  template = NULL,
  col_range = NULL,
  col_scale = NULL,
  contour = FALSE,
  show_legend = TRUE,
  label_sensors = FALSE
)
}
\arguments{
\item{data}{A data frame, tibble or a database table with input data to plot. It should be an output from \code{\link{compute_mean}} function or an object with the same structure, containing columns: \code{sensor} with sensor labels and \code{average}, \code{ci_low}, \code{ci_up} with values of average signal and its lower and upper CI bounds in one time point (or precomputed average of multiple time points).}

\item{mesh}{A \code{"mesh"} object (or a named list with the same structure) containing at least \code{D2} element with x and y coordinates of a point mesh used for computing IM model. If not defined, the point mesh with default settings from \code{\link{point_mesh}} function is used.}

\item{coords}{Sensor coordinates as a tibble or data frame with named \code{x}, \code{y} and \code{sensor} columns. The \code{sensor} labels must match the labels in sensor column in \code{data}. If not defined, the HCGSN256 template is used.}

\item{template}{The kind of sensor template montage used. Currently the only available option is \code{"HCGSN256"} denoting the 256-channel HydroCel Geodesic Sensor Net v.1.0, which is also a default setting.}

\item{col_range}{A vector with minimum and maximum value of the amplitude used in the colour palette for plotting. If not defined, the range of input data (average and CI bounds) is used.}

\item{col_scale}{Optionally, a colour scale to be utilised for plotting. It should be a list with \code{colors} and \code{breaks} components (usually created via \code{\link{create_scale}}). If not defined, it is computed from \code{col_range}.}

\item{contour}{Logical. Indicates, whether contours should be plotted in the graph. Default value is \code{FALSE}.}

\item{show_legend}{Logical. Indicates, whether legend should be displayed below the graph. Default value is \code{TRUE}.}

\item{label_sensors}{A logical value indicating whether the sensor labels should also be plotted. Default value is \code{FALSE}.}
}
\value{
A \code{ggplot} object showing the static topographic map of the signal divided into three panels: CI lower, mean, CI upper.
}
\description{
Plot a topographic circle or polygon map of the average EEG signal amplitude and its lower and upper confidence interval bounds using topographic colour scale.
The thin-plate spline interpolation model \eqn{\text{IM:}\; \mathbb{R}^2 \rightarrow \mathbb{R}} is used for signal interpolation between the sensor locations.
The output in the form of a \code{ggplot} object allows to easily edit the result image properties.
}
\details{
The spline interpolation is done independently for each CI bound and average.

Note: When specifying the \code{coords} and \code{template} at the same time, the \code{template} parameter takes precedence and the \code{coords} parameter is ignored.
}
\examples{
# Plot average topographic map with CI bounds of signal for subject 2 from the time point 10
# (the time of the stimulus) excluding outlier epochs 14 and 15

# a) preparing data
# a1) extract required data
edata <- pick_data(epochdata, subject_rg = 2, epoch_rg = 1:13, time_rg = 1:10)
# a2) baseline correction (needed for suitable topographic map)
data_base <- baseline_correction(edata, baseline_range = 1:10)
# a3) average computing
data_mean <- data_base |>
dplyr::filter(time == 10) |>
compute_mean(amplitude = "signal_base", type = "jack", domain = "space")
# a4) prepare a mesh for plotting
M <- point_mesh(dimension = 2, n = 3000, template = "HCGSN256",
sensor_select = unique(epochdata$sensor))

# b) plot the topographic map with legend
plot_topo_mean(data = data_mean, mesh = M, template = "HCGSN256", show_legend = TRUE)
}
\seealso{
\code{\link{topo_plot}}, \code{\link{compute_mean}}, animated version: \code{\link{animate_topo_mean}}
}
