% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acc_cat_distributions.R
\name{acc_cat_distributions}
\alias{acc_cat_distributions}
\title{Plots and checks for distributions for categorical variables}
\usage{
acc_cat_distributions(
  resp_vars = NULL,
  group_vars = NULL,
  study_data,
  label_col,
  item_level = "item_level",
  meta_data = item_level,
  meta_data_v2,
  n_cat_max = getOption("dataquieR.max_cat_resp_var_levels_in_plot",
    dataquieR.max_cat_resp_var_levels_in_plot_default),
  n_group_max = getOption("dataquieR.max_group_var_levels_in_plot",
    dataquieR.max_group_var_levels_in_plot_default),
  n_data_min = getOption("dataquieR.min_time_points_for_cat_resp_var",
    dataquieR.min_time_points_for_cat_resp_var_default)
)
}
\arguments{
\item{resp_vars}{\link{variable} the name of the measurement variable}

\item{group_vars}{\link{variable} the name of the observer, device or
reader variable}

\item{study_data}{\link{data.frame} the data frame that contains the measurements}

\item{label_col}{\link{variable attribute} the name of the column in the metadata
with labels of variables}

\item{item_level}{\link{data.frame} the data frame that contains metadata
attributes of study data}

\item{meta_data}{\link{data.frame} old name for \code{item_level}}

\item{meta_data_v2}{\link{character} path to workbook like metadata file, see
\code{\link{prep_load_workbook_like_file}} for details.
\strong{ALL LOADED DATAFRAMES WILL BE PURGED},
using \code{\link{prep_purge_data_frame_cache}},
if you specify \code{meta_data_v2}.}

\item{n_cat_max}{maximum number of categories to be displayed individually
for the categorical variable (\code{resp_vars})}

\item{n_group_max}{maximum number of categories to be displayed individually
for the grouping variable (\code{group_vars}, devices / examiners)}

\item{n_data_min}{minimum number of data points to create a time course plot
for an individual category of the \code{resp_vars} variable}
}
\value{
A \link{list} with:
\itemize{
\item \code{SummaryPlot}: \link[ggplot2:ggplot]{ggplot2::ggplot} for the response variable in
\code{resp_vars}.
}
}
\description{
This function creates distribution plots for categorical variables.

\link{Descriptor}
}
\details{
To complete
}
\seealso{
\href{https://dataquality.qihs.uni-greifswald.de/}{Online Documentation}
}
