% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{credit_card.int}
\alias{credit_card.int}
\title{Credit Card Expenses Interval Dataset}
\format{
A data frame with person-month rows and 5 interval-valued columns:
\itemize{
    \item \code{food}: Food expenditure range (USD).
    \item \code{social}: Social expenditure range (USD).
    \item \code{travel}: Travel expenditure range (USD).
    \item \code{gas}: Gas expenditure range (USD).
    \item \code{clothes}: Clothes expenditure range (USD).
}
}
\usage{
data(credit_card.int)
}
\description{
Interval-valued credit card spending aggregated by person-month.
Three individuals' (Jon, Tom, Leigh) monthly expenditures across
five categories.
}
\details{
The original classical dataset (Table 2.3) records individual
transactions. The symbolic version (Table 2.4) aggregates into
interval-valued observations for each person-month combination.
}
\examples{
data(credit_card.int)
}
\references{
Billard, L. and Diday, E. (2006). \emph{Symbolic Data Analysis}. Wiley.
Tables 2.3-2.4.
}
\keyword{datasets}
\keyword{interval}
