% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_lsratio.R
\name{get_lsratio}
\alias{get_lsratio}
\title{Get the long to short ratio of a cryptocurrency pair}
\usage{
get_lsratio(
   ticker,
   interval = '1d',
   source   = 'binance',
   from     = NULL,
   to       = NULL,
   top      = FALSE
)
}
\arguments{
\item{ticker}{A \link{character}-vector of \link{length} 1.
See \code{\link[=available_tickers]{available_tickers()}} for available tickers.}

\item{interval}{A \link{character}-vector of \link{length} 1. \verb{1d} by default.
See \code{\link[=available_intervals]{available_intervals()}} for available intervals.}

\item{source}{A \link{character}-vector of \link{length} 1. \code{binance} by default.
See \code{\link[=available_exchanges]{available_exchanges()}} for available exchanges.}

\item{from}{An optional \link{character}-, \link{date}- or
\link{POSIXct}-vector of \link{length} 1. \link{NULL} by default.}

\item{to}{An optional \link{character}-, \link{date}- or
\link{POSIXct}-vector of \link{length} 1. \link{NULL} by default.}

\item{top}{A \link{logical} vector. \link{FALSE} by default.
If \link{TRUE} it returns the top traders Long-Short ratios.}
}
\value{
An \link[xts:xts]{xts::xts}-object containing,

\item{index}{<\link{POSIXct}> the time-index}
\item{long}{<\link{numeric}> the share of longs}
\item{short}{<\link{numeric}> the share of shorts}
\item{ls_ratio}{<\link{numeric}> the ratio of longs to shorts}

\strong{Sample output}

\if{html}{\out{<div class="sourceCode">}}\preformatted{#>                       long  short  ls_ratio
#> 2024-05-12 02:00:00 0.6930 0.3070 2.2573290
#> 2024-05-13 02:00:00 0.6637 0.3363 1.9735355
#> 2024-05-14 02:00:00 0.5555 0.4445 1.2497188
#> 2024-05-15 02:00:00 0.6580 0.3420 1.9239766
#> 2024-05-16 02:00:00 0.4868 0.5132 0.9485581
#> 2024-05-17 02:00:00 0.5102 0.4898 1.0416497
}\if{html}{\out{</div>}}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Get the long-short ratio for any \code{\link[=available_tickers]{available_tickers()}}
from the \code{\link[=available_exchanges]{available_exchanges()}}
}
\details{
\subsection{On time-zones and dates}{

Values passed to \verb{from`` or }to\verb{must be coercible by [as.Date()], or [as.POSIXct()], with a format of either}"\%Y-\%m-\%d"\code{or}"\%Y-\%m-\%d \%H:\%M:\%S"`. By default all dates are passed and
returned with \code{\link[=Sys.timezone]{Sys.timezone()}}.
}

\subsection{On returns}{

If only \code{from} is provided 200 pips are returned up to \code{Sys.time()}.
If only \code{to} is provided 200 pips up to the specified date is returned.
}
}
\examples{
\dontrun{
  # script start;

  LS_BTC <- cryptoQuotes::get_lsratio(
    ticker   = 'BTCUSDT',
    interval = '15m',
    from     = Sys.Date() - 1,
    to       = Sys.Date()
  )

  # end of scrtipt;
}

}
\seealso{
Other get-functions: 
\code{\link{get_fgindex}()},
\code{\link{get_fundingrate}()},
\code{\link{get_mktcap}()},
\code{\link{get_openinterest}()},
\code{\link{get_quote}()}
}
\author{
Jonas Cuzulan Hirani
}
\concept{get-functions}
