% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Samples-class.R
\docType{class}
\name{Samples-class}
\alias{Samples-class}
\alias{.Samples}
\alias{Samples}
\alias{.DefaultSamples}
\title{\code{Samples}}
\usage{
Samples(data, options)

.DefaultSamples()
}
\arguments{
\item{data}{see slot definition.}

\item{options}{see slot definition.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

\code{\link{Samples}} is the class to store the MCMC samples.
}
\section{Slots}{

\describe{
\item{\code{data}}{(\code{list})\cr MCMC samples of the parameter. Each entry in this list
must be a vector (in case of a scalar parameter) or matrix (in case of a
vector-valued parameter) with samples.
In case of matrix, every row is a separate sample, while columns correspond
to the dimension of the parameter.}

\item{\code{options}}{(\code{McmcOptions})\cr MCMC options that were used to generate the
samples.}
}}

\note{
Typically, end users will not use the \code{.DefaultSamples()} function.
}
\examples{
# The MCMC options that were used to generate the samples.
my_options <- McmcOptions(
  burnin = 1000,
  step = 2,
  samples = 1000
)

# Create an object of class 'Samples'
# Here the parameters 'alpha' and 'beta' are randomly generated. Of course, in
# a real example these would be a samples coming from MCMC procedures.
my_samples <- Samples(
  data = list(alpha = rnorm(1000), beta = rnorm(1000)),
  options = my_options
)
}
