% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qpdf.R
\name{pdf_subset}
\alias{pdf_subset}
\title{Subset a pdf file to a new pdf file containing the selected pages}
\usage{
pdf_subset(input, pages = 1, output = NULL, password = "")
}
\arguments{
\item{input}{path or url to the input pdf file}

\item{pages}{a vector with page numbers to select. Negative numbers
means removing those pages (same as R indexing)}

\item{output}{base path of the output file(s)}

\item{password}{string with password to open pdf file}
}
\value{
a character vector with the path of the subsetted pdf file
}
\description{
Subset a pdf file to a new pdf file containing the selected pages
}
\examples{
pdf_file <- system.file("examples", "sufganiyot.pdf", package = "cpp11qpdf")
fout <- tempfile()
pdf_subset(pdf_file, 1, fout, "")
}
