% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{visualize_factor_dynamics_simple}
\alias{visualize_factor_dynamics_simple}
\title{Simple factor dynamics visualization}
\usage{
visualize_factor_dynamics_simple(
  factors_data,
  output_file = NULL,
  verbose = TRUE
)
}
\arguments{
\item{factors_data}{List containing factor scores.}

\item{output_file}{Character string. Optional file path for saving. Default is \code{NULL}.}

\item{verbose}{Logical; print progress and diagnostic information. Default \code{TRUE}.}
}
\value{
Invisibly returns \code{NULL}.
}
\description{
Creates a simplified multi-panel plot of factor scores over time with
minimal dependencies. Useful for quick diagnostics.
}
\examples{
\donttest{
data <- list(scores_X = matrix(rnorm(100), ncol = 2),
             scores_Y = matrix(rnorm(100), ncol = 2))
tmp_file <- file.path(tempdir(), "test_plot.pdf")
visualize_factor_dynamics_simple(data, output_file = tmp_file)
}
}
