% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/schedule.R
\name{set_schedule}
\alias{set_schedule}
\alias{set_schedule_minute}
\alias{set_schedule_hour}
\alias{set_schedule_day}
\alias{set_schedule_weekday}
\alias{set_schedule_week}
\alias{set_schedule_dayofweek}
\alias{set_schedule_semimonth}
\alias{set_schedule_dayofmonth}
\alias{set_schedule_dayweekofmonth}
\alias{set_schedule_year}
\alias{set_schedule_remove}
\alias{schedule_describe}
\title{Set a Schedule}
\usage{
set_schedule(.schedule, ...)

set_schedule_minute(
  .schedule,
  n = 30,
  start_time = Sys.time(),
  activate = TRUE,
  email = FALSE,
  timezone = Sys.timezone()
)

set_schedule_hour(
  .schedule,
  n = 1,
  start_time = Sys.time(),
  activate = TRUE,
  email = FALSE,
  timezone = Sys.timezone()
)

set_schedule_day(
  .schedule,
  n = 1,
  start_time = Sys.time(),
  activate = TRUE,
  email = FALSE,
  timezone = Sys.timezone()
)

set_schedule_weekday(
  .schedule,
  start_time = Sys.time(),
  activate = TRUE,
  email = FALSE,
  timezone = Sys.timezone()
)

set_schedule_week(
  .schedule,
  n = 1,
  start_time = Sys.time(),
  activate = TRUE,
  email = FALSE,
  timezone = Sys.timezone()
)

set_schedule_dayofweek(
  .schedule,
  days,
  start_time = Sys.time(),
  activate = TRUE,
  email = FALSE,
  timezone = Sys.timezone()
)

set_schedule_semimonth(
  .schedule,
  first = TRUE,
  start_time = Sys.time(),
  activate = TRUE,
  email = FALSE,
  timezone = Sys.timezone()
)

set_schedule_dayofmonth(
  .schedule,
  n = 1,
  day = 1,
  start_time = Sys.time(),
  activate = TRUE,
  email = FALSE,
  timezone = Sys.timezone()
)

set_schedule_dayweekofmonth(
  .schedule,
  n = 1,
  day = 1,
  week = 1,
  start_time = Sys.time(),
  activate = TRUE,
  email = FALSE,
  timezone = Sys.timezone()
)

set_schedule_year(
  .schedule,
  n = 1,
  start_time = Sys.time(),
  activate = TRUE,
  email = FALSE,
  timezone = Sys.timezone()
)

set_schedule_remove(.schedule)

schedule_describe(.schedule)
}
\arguments{
\item{.schedule}{A schedule object. As returned by \code{get_variant_schedule()}}

\item{...}{Scheduling parameters}

\item{n}{The "number of" iterations}

\item{start_time}{The start time of the schedule}

\item{activate}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} This parameter no longer
has any effect due to changes in the Connect API and will be removed in a
future release.}

\item{email}{Whether to send emails on this schedule}

\item{timezone}{The timezone to use for setting the schedule. Defaults to \code{Sys.timezone()}}

\item{days}{The days of the week (0-6)}

\item{first}{\link{logical} Whether to execute on the 1st and 15th (TRUE) or 14th and last (FALSE)}

\item{day}{The day of the week (0-6) or day of the month (0-31)}

\item{week}{The week of the month (0-5)}

\item{schedule}{A JSON blob (as a string) describing the schedule. See "More Details"}
}
\value{
An updated Schedule object
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Sets the schedule for a given Variant. Requires a
\code{Schedule} object (as returned by \code{get_variant_schedule()})
}
\details{
\itemize{
\item \code{set_schedule()} is a raw interface to Posit Connect's \code{schedule} API
\item \verb{set_schedule_*()} functions provide handy wrappers around \code{set_schedule()}
\item \code{set_schedule_remove()} removes a schedule / un-schedules a variant
}

Beware, using \code{set_schedule()} currently uses the Posit Connect \code{schedule} API
directly, and so can be a little clunky. Using the \verb{set_schedule_*()} is generally
recommended.
}
\seealso{
Other schedule functions: 
\code{\link{get_timezones}()},
\code{\link{get_variant_schedule}()}
}
\concept{schedule functions}
