% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/content.R
\name{get_environment}
\alias{get_environment}
\alias{set_environment_new}
\alias{set_environment_remove}
\alias{set_environment_all}
\title{Manage Environment Variables}
\usage{
get_environment(content)

set_environment_new(env, ...)

set_environment_remove(env, ...)

set_environment_all(env, ...)
}
\arguments{
\item{content}{An R6 Content object as returned by \code{content_item()}}

\item{env}{An R6 Environment object as returned by \code{get_environment()}}

\item{...}{name = value pairs of environment variable names and values}
}
\description{
Manage Environment Variables for a piece of content.
}
\details{
\code{get_environment()} returns an Environment object for use with "setter" methods

\code{set_environment_new()} updates environment values (either creating new
values or updating existing). Set \code{NA} as the value to remove a variable.

\code{set_environment_remove()} is a wrapper on \code{set_environment_new()} that
allows removing named / listed variables quickly

\code{set_environment_all()} sets \emph{all} environment variable values (will remove
variables not specified)
}
\seealso{
Other content functions: 
\code{\link{content_delete}()},
\code{\link{content_item}()},
\code{\link{content_title}()},
\code{\link{content_update}()},
\code{\link{create_random_name}()},
\code{\link{dashboard_url}()},
\code{\link{delete_thumbnail}()},
\code{\link{delete_vanity_url}()},
\code{\link{deploy_repo}()},
\code{\link{get_associations}()},
\code{\link{get_bundles}()},
\code{\link{get_jobs}()},
\code{\link{get_log}()},
\code{\link{get_thumbnail}()},
\code{\link{get_vanity_url}()},
\code{\link{git}},
\code{\link{has_thumbnail}()},
\code{\link{lock_content}()},
\code{\link{permissions}},
\code{\link{search_content}()},
\code{\link{set_integrations}()},
\code{\link{set_run_as}()},
\code{\link{set_thumbnail}()},
\code{\link{set_vanity_url}()},
\code{\link{swap_vanity_urls}()},
\code{\link{terminate_jobs}()},
\code{\link{verify_content_name}()}
}
\concept{content functions}
