% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/problem.R
\name{get_score}
\alias{get_score}
\title{Get score function from problem}
\usage{
get_score(problem)
}
\arguments{
\item{problem}{An mle_problem object}
}
\value{
Score function that takes a parameter vector and returns the
  gradient of the log-likelihood.
}
\description{
Returns the score (gradient) function, computing numerically if not provided.
If \code{cache_derivatives = TRUE} was set in the problem and score is
computed numerically, results are cached using a single-value cache.
}
\examples{
problem <- mle_problem(
  loglike = function(theta) -sum((theta - c(1, 2))^2)
)
score_fn <- get_score(problem)
score_fn(c(0, 0))  # Gradient at (0, 0)
}
